package com.netease.yanxuan.wx.store.sharer.biz.job;

import com.netease.mail.yanxuan.dschedule.core.biz.model.ReturnT;
import com.netease.mail.yanxuan.dschedule.core.handler.IJobHandler;
import com.netease.mail.yanxuan.dschedule.core.handler.annotation.JobHandler;
import com.netease.yanxuan.wx.store.sharer.biz.service.ICommissionOrderService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

/**
 * @Description 微信小店佣金订单数据同步失败重试任务
 * @Author fanjiaxin
 * @Date 2025/3/27 19:08
 */
@Slf4j
@RequiredArgsConstructor
@Component
@JobHandler("weChatCommissionOrderFailRetryJob")
public class WeChatCommissionOrderFailRetryJob extends IJobHandler {

    private final ICommissionOrderService iCommissionOrderService;


    @Override
    public ReturnT<String> execute(String... strings) {
        log.info("[op:weChatCommissionOrderFailRetryJob] start...");
        iCommissionOrderService.doCommissionOrderFailRetry();
        log.info("[op:weChatCommissionOrderFailRetryJob] end...");
        return ReturnT.SUCCESS;
    }
}
