package com.netease.yanxuan.wx.store.sharer.common.constant;

/**
 * @Description 通用常量信息
 * @Author fanjiaxin
 * @Date 2025/3/9 13:15
 */
public interface CoreConstant {
    /**
     * 请求头认证Token
     */
    String AUTH_HEADER_TOKEN_KEY = "Authorization";

    /**
     * Redis用户认证Token
     */
    String REDIS_TOKEN_USER_KEY = "TOKEN:USER:";
    /**
     * Redis认证Token失效时间，秒
     */
    int REDIS_TOKEN_EXPIRE_SECONDS = 30 * 24 * 60 * 60;


    /**
     * Redis微信认证Token
     */
    String REDIS_TOKEN_WECHAT_KEY = "TOKEN:WECHAT";
    /**
     * Redis微信认证Token锁
     */
    String REDIS_TOKEN_WECHAT_LOCK_KEY = "TOKEN:WECHAT:LOCK";
    /**
     * Redis微信认证Token锁时间，秒
     */
    String REDIS_TOKEN_WECHAT_LOCK_VALUE = "wechat:lock";
    /**
     * Redis微信认证Token锁时间，秒
     */
    int REDIS_TOKEN_WECHAT_LOCK_TIME = 5;

    /**
     * Redis微信小店认证Token
     */
    String REDIS_TOKEN_WECHAT_SHOP_KEY = "TOKEN:WECHAT:SHOP";
    /**
     * Redis微信小店认证Token锁
     */
    String REDIS_TOKEN_WECHAT_SHOP_LOCK_KEY = "TOKEN:WECHAT:SHOP:LOCK";
    /**
     * Redis微信小店认证Token锁时间，秒
     */
    String REDIS_TOKEN_WECHAT_SHOP_LOCK_VALUE = "wechat:shop:lock";
    /**
     * Redis微信小店认证Token锁时间，秒
     */
    int REDIS_TOKEN_WECHAT_SHOP_LOCK_TIME = 5;
}
