package com.netease.yanxuan.wx.store.sharer.common.handler;

import com.alibaba.fastjson.JSON;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.*;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

import java.net.URI;
import java.util.Map;
import java.util.Objects;

/**
 * @Description RestTemplateClient
 * @Author fanjiaxin
 * @Date 2025/3/11 17:27
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class RestTemplateClient implements HttpRequestClient {
    private final RestTemplate restTemplate;

    @Override
    public <T> String execute(String url, HttpMethod method, T params) {
        log.info("RestTemplateClient execute url:{},method:{},params:{}", url, method, JSON.toJSONString(params));
        if (method == HttpMethod.GET) {
            return handleGetRequest(url, params);
        } else {
            return handlePostRequest(url, params);
        }
    }

    private <T> String handleGetRequest(String url, T params) {
        UriComponentsBuilder builder = UriComponentsBuilder.fromHttpUrl(url);
        if (Objects.nonNull(params)) {
            Map<String, Object> paramsMap = JSON.parseObject(JSON.toJSONString(params), Map.class);
            paramsMap.forEach(builder::queryParam);
        }
        URI uri = builder.build().toUri();
        log.info("RestTemplateClient handleGetRequest execute uri:{}", uri);
        String result = restTemplate.getForObject(uri, String.class);
        log.info("RestTemplateClient handleGetRequest execute response:{}", result);
        return result;
    }

    private <T> String handlePostRequest(String url, T params) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity<T> requestEntity = new HttpEntity<>(params, headers);
        String result = restTemplate.postForObject(url, requestEntity, String.class);
        log.info("RestTemplateClient handlePostRequest execute response:{}", result);
        return result;
    }
}

