package com.netease.yanxuan.wx.store.sharer.integration.config;

import com.ctrip.framework.apollo.spring.annotation.EnableAutoUpdateApolloConfig;
import com.ctrip.framework.apollo.spring.annotation.ValueMapping;
import com.netease.yanxuan.wx.store.sharer.integration.meta.model.bo.SmsCodeScenesConfigBO;
import lombok.Data;
import org.springframework.stereotype.Component;

import java.util.Map;

/**
 * @Description 应用配置
 * @Author fanjiaxin
 * @Date 2025/3/10 17:26
 */
@Data
@Component
@EnableAutoUpdateApolloConfig("sms.config")
public class SmsConfig {
    /**
     * 场景验证码配置
     * key: 业务场景标识
     */
    @ValueMapping("${scenes.config.map:{\"REAL_NAME_AUTHENTICATED\":{\"sendIntervalSeconds\":60,\"codeValidMinutes\":5,\"messageFormat\":\"【网易】验证码:%s，您正在实名认证，%s分钟内输入有效（若非本人操作，请删除本短信）\",\"sendMaxCount\":10}}}")
    private Map<String, SmsCodeScenesConfigBO> scenesConfigMap;


    public SmsCodeScenesConfigBO getScenesConfig(String scenes) {
        return scenesConfigMap.get(scenes);
    }
}