package com.netease.yanxuan.wx.store.sharer.integration.handler.impl;

import com.netease.yanxuan.wx.store.sharer.integration.config.WeChatConfig;
import com.netease.yanxuan.wx.store.sharer.integration.constant.WeChatApi;
import com.netease.yanxuan.wx.store.sharer.integration.core.WeChatContextHolder;
import com.netease.yanxuan.wx.store.sharer.integration.handler.IWeChatRequest;
import com.netease.yanxuan.wx.store.sharer.integration.handler.WeChatRestTemplateHandler;
import com.netease.yanxuan.wx.store.sharer.integration.meta.model.bo.WeChatCommissionOrderListBO;
import com.netease.yanxuan.wx.store.sharer.integration.meta.model.bo.WeChatTimeRangeBO;
import com.netease.yanxuan.wx.store.sharer.integration.meta.model.vo.WeChatCommissionOrderListVO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Service;

/**
 * @Description 微信小店-分佣单列表请求
 * @Author fanjiaxin
 * @Date 2025/3/11 17:33
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class WeChatCommissionOrderListRequest implements IWeChatRequest {
    private final WeChatContextHolder weChatContextHolder;
    private final WeChatRestTemplateHandler weChatRestTemplateHandler;
    private final WeChatConfig weChatConfig;


    @Override
    public HttpMethod getRequestMethod() {
        return HttpMethod.POST;
    }

    @Override
    public String getRequestUrl() {
        return weChatConfig.getUrl() + WeChatApi.GET_COMMISSION_ORDER_LIST
                + "?" + WeChatApi.WECHAT_REQUEST_TOKEN_FIELD_NAME + "="
                + weChatContextHolder.getShopAccessToken();
    }

    /**
     * 处理
     */
    public WeChatCommissionOrderListVO handle(Long startTime, Long endTime, String nextKey, Integer pageSize) {
        WeChatCommissionOrderListBO params = WeChatCommissionOrderListBO.builder()
                .update_time_range(WeChatTimeRangeBO.builder().start_time(startTime).end_time(endTime).build())
                .next_key(nextKey)
                .page_size(pageSize)
                .build();
        return weChatRestTemplateHandler.execute(getRequestUrl(), getRequestMethod(),
                params, WeChatCommissionOrderListVO.class);
    }
}
