package com.netease.yanxuan.wx.store.sharer.dal.config;

import com.alibaba.druid.pool.DruidDataSource;
import com.baomidou.mybatisplus.annotation.DbType;
import com.baomidou.mybatisplus.extension.plugins.MybatisPlusInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.PaginationInnerInterceptor;
import com.baomidou.mybatisplus.extension.spring.MybatisSqlSessionFactoryBean;
import com.netease.yanxuan.shadow.common.IDGenerator;
import com.netease.yanxuan.shadow.conf.DrmShadowConfig;
import com.netease.yanxuan.shadow.conf.ShadowConfig;
import com.netease.yanxuan.shadow.ddb.IDGeneratorDipperDDB;
import com.netease.yanxuan.shadow.druid.ShadowTableFilter;
import lombok.extern.slf4j.Slf4j;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;

import javax.sql.DataSource;
import java.util.Collections;

@Slf4j
@Configuration
@EnableTransactionManagement
public class DataSourceConfiguration {

    @Autowired
    private DrmDBConfig drmDBConfig;

    @Bean("mysqlDataSource")
    public DataSource genDataSource(@Qualifier("shadowTableFilter") ShadowTableFilter shadowTableFilter) {
        DruidDataSource dataSource = new DruidDataSource();
        //url
        dataSource.setUrl(drmDBConfig.getMysqlUrl());
        dataSource.setUsername(drmDBConfig.getMysqlUserName());
        dataSource.setPassword(drmDBConfig.getMysqlPassWord());
        dataSource.setDriverClassName(drmDBConfig.getMysqlDriverClassName());

        //pool
        dataSource.setDbType(drmDBConfig.getMysqlDbType());
        dataSource.setInitialSize(drmDBConfig.getMysqlInitialSize());
        dataSource.setMinIdle(drmDBConfig.getMysqlMinIdle());
        dataSource.setMaxActive(drmDBConfig.getMysqlMaxActive());
        dataSource.setMaxWait(drmDBConfig.getMysqlMaxWait());
        dataSource.setMinEvictableIdleTimeMillis(drmDBConfig.getMysqlMinEvictableTimeMillis());
        dataSource.setRemoveAbandoned(drmDBConfig.isMysqlRemoveAbandoned());
        dataSource.setRemoveAbandonedTimeoutMillis(drmDBConfig.getMysqlRemoveAbandonedTimeMills());
        dataSource.setUseUnfairLock(drmDBConfig.isMysqlUseUnfairLock());
        dataSource.setTestWhileIdle(drmDBConfig.isMysqlTestWhileIdle());
        dataSource.setValidationQuery(drmDBConfig.getMysqlValidationQuery());
        dataSource.setValidationQueryTimeout(drmDBConfig.getMysqlValidationQueryTimeout());
        dataSource.setTimeBetweenEvictionRunsMillis(drmDBConfig.getMysqlTimeBetweenEvictionRunsMillis());
        dataSource.setTestOnBorrow(drmDBConfig.isMysqlTestOnBorrow());
        dataSource.setTestOnReturn(drmDBConfig.isMysqlTestOnReturn());
        dataSource.setPoolPreparedStatements(drmDBConfig.isMysqlPoolPreparedStatements());
        dataSource.setMaxPoolPreparedStatementPerConnectionSize(
                drmDBConfig.getMysqlMaxPoolPreparedStatementPerConnectionSize());
        dataSource.setProxyFilters(Collections.singletonList(shadowTableFilter));
        dataSource.setDriverClassName("com.mysql.jdbc.Driver");
        dataSource.setDbType("mysql");
        return dataSource;
    }

    /**
     * session factory
     */
    @Primary
    @Bean(name = "sqlSessionFactoryBean")
    public MybatisSqlSessionFactoryBean sqlSessionFactoryBean(DataSource dataSource) throws Exception {
        MybatisSqlSessionFactoryBean sqlSessionFactoryBean = new MybatisSqlSessionFactoryBean();
        sqlSessionFactoryBean.setDataSource(dataSource);

        // 配置类型别名
        sqlSessionFactoryBean.setTypeAliasesPackage("com.netease.yanxuan.marketing.mall.reward.dal.meta.model.po");

        // 配置mapper的扫描，找到所有的mapper.xml映射文件
        PathMatchingResourcePatternResolver patternResolver = new PathMatchingResourcePatternResolver();
        Resource[] resources = patternResolver.getResources("classpath:mapper/*.xml");
        sqlSessionFactoryBean.setMapperLocations(resources);

        // 加载全局的配置文件
        DefaultResourceLoader defaultResourceLoader = new DefaultResourceLoader();
        Resource resource = defaultResourceLoader.getResource("classpath:mybatis/mybatis-config.xml");
        sqlSessionFactoryBean.setConfigLocation(resource);

        sqlSessionFactoryBean.setPlugins(mybatisPlusInterceptor());
        return sqlSessionFactoryBean;
    }

    /**
     * sqlSessionTemplate
     */
    @Primary
    @Bean(name = "sqlSessionTemplate")
    public SqlSessionTemplate sqlSessionTemplate(SqlSessionFactory sqlSessionFactory) {
        return new SqlSessionTemplate(sqlSessionFactory);
    }

    /**
     * 用于事务管理
     */
    @Bean(name = "transactionManager")
    @Primary
    public PlatformTransactionManager transactionManager(DataSource dataSource) {
        return new DataSourceTransactionManager(dataSource);
    }

    @Bean
    public MybatisPlusInterceptor mybatisPlusInterceptor() {
        MybatisPlusInterceptor interceptor = new MybatisPlusInterceptor();
        interceptor.addInnerInterceptor(new PaginationInnerInterceptor(DbType.MYSQL));
        return interceptor;
    }

    @Bean
    public ShadowConfig shadowConfig() {
        return new DrmShadowConfig();
    }

    @Bean
    public IDGenerator ddbIDGenerator(ShadowConfig shadowConfig) {
        return new IDGeneratorDipperDDB(shadowConfig);
    }

    @Bean
    public ShadowTableFilter shadowTableFilter(@Qualifier("shadowConfig") ShadowConfig shadowConfig) {
        ShadowTableFilter shadowTableFilter = new ShadowTableFilter();
        shadowTableFilter.setShadowConfig(shadowConfig);
        return shadowTableFilter;
    }

}
