package com.netease.yanxuan.wx.store.sharer.biz.meta.page;

import lombok.Data;
import org.springframework.util.CollectionUtils;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;

/**
 * 分页数据对象
 */
@Data
public class PageVO<T> implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     * 是否有下一页
     */
    private Boolean hasMore;

    /**
     * 翻页的上下文，用于请求下一页
     */
    private String nextKey;

    /**
     * 列表数据
     */
    private List<T> list;

    public List<T> getList() {
        return CollectionUtils.isEmpty(list) ? Collections.emptyList() : list;
    }
}
