package com.netease.yanxuan.wx.store.sharer.dal.meta.model.po;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.Date;

/**
 * @Description 推客商品分佣配置操作记录表
 * @Author fanjiaxin
 * @Date 2025/3/11 21:54
 */
@Data
@TableName("SHARER_PRODUCT_COMMISSION_RECORD")
public class SharerProductCommissionRecord implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     * 主键ID，自动生成。
     */
    @TableId(type = IdType.AUTO)
    private BigInteger id;
    /**
     * 用户开放ID
     */
    private String openId;
    /**
     * 推客应用ID
     */
    private String sharerAppid;
    /**
     * 商品ID
     */
    private String productId;
    /**
     * 操作类型
     * 1- 设置商品分佣比例
     * 2- 取消设置商品分佣比例
     * 3- 默认分佣比例变更
     */
    private String optType;
    /**
     * 操作信息，记录操作前比例 & 操作后比例
     */
    private String optInfo;
    /**
     * 操作时间
     */
    private Date optTime;
    /**
     * 状态，1 操作成功 2 操作失败
     */
    private String optStatus;
    /**
     * 拓展信息
     */
    private String extInfo;
    /**
     * 创建时间
     */
    private Date createTime;
    /**
     * 更新时间
     */
    private Date updateTime;
}

