package com.netease.yanxuan.wx.store.sharer.assembly;

import com.ctrip.framework.apollo.spring.annotation.EnableApolloConfig;
import com.netease.yanxuan.missa.client.annotation.EnableMissaClients;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.web.servlet.support.SpringBootServletInitializer;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.scheduling.annotation.EnableAsync;

/**
 * 项目启动类
 */
@EnableAsync
@EnableApolloConfig
@EnableMissaClients(basePackages = "com.netease.yanxuan.wx.store.sharer")
@MapperScan(basePackages = "com.netease.yanxuan.wx.store.sharer.dal")
@ComponentScan(basePackages = {"com.netease.mail.yanxuan.dschedule", "com.netease.yanxuan.wx.store.sharer"})
@SpringBootApplication
public class Application extends SpringBootServletInitializer {

    public static void main(String[] args) {
        SpringApplication.run(Application.class, args);
    }
}
