package com.netease.yanxuan.wx.store.sharer.integration.handler;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.netease.yanxuan.wx.store.sharer.common.exception.WeChatException;
import com.netease.yanxuan.wx.store.sharer.common.handler.RedisClient;
import com.netease.yanxuan.wx.store.sharer.common.handler.RestTemplateClient;
import com.netease.yanxuan.wx.store.sharer.integration.constant.WeChatApi;
import com.netease.yanxuan.wx.store.sharer.integration.constant.WeChatConstant;
import com.netease.yanxuan.wx.store.sharer.integration.meta.enums.WeChatErrorCodeEnum;
import com.netease.yanxuan.wx.store.sharer.integration.meta.model.vo.WeChatCoreVO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Service;

/**
 * @Description RestTemplateClient
 * @Author fanjiaxin
 * @Date 2025/3/11 17:27
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class WeChatRestTemplateHandler {
    private final RestTemplateClient restTemplateClient;
    private final RedisClient redisClient;


    public <T, R extends WeChatCoreVO> R execute(String url, HttpMethod method, T params, Class<R> resType) {
        R result;
        try {
            log.info("[op:WeChatRestTemplateHandler.execute] url:{} params:{}", url, JSONObject.toJSONString(params));
            String resultJson = restTemplateClient.execute(url, method, params);
            log.info("[op:WeChatRestTemplateHandler.execute] result:{}", resultJson);
            result = JSON.parseObject(resultJson, resType);
        } catch (Exception e) {
            log.info("[op:WeChatRestTemplateHandler.execute] is error", e);
            throw new WeChatException(e);
        }
        if (StringUtils.isNotBlank(result.getErrcode())
                && !WeChatApi.WECHAT_REQUEST_SUCCESS_CODE.equals(result.getErrcode())) {
            if(WeChatErrorCodeEnum.INVALID_CREDENTIAL.getCode().equals(result.getErrcode())){
                // token过期,清除微信小店认证信息
                redisClient.delete(WeChatConstant.REDIS_TOKEN_WECHAT_SHOP_KEY);
            }
            throw new WeChatException(String.join("，","调用微信接口失败" + result.getErrmsg()));
        }
        return result;
    }
}

