package com.netease.yanxuan.wx.store.sharer.common.handler;


import com.netease.yanxuan.wx.store.sharer.common.constant.HttpStatusConstant;
import com.netease.yanxuan.wx.store.sharer.common.core.Result;
import com.netease.yanxuan.wx.store.sharer.common.exception.BizException;
import com.netease.yanxuan.wx.store.sharer.common.exception.NoAuthException;
import com.netease.yanxuan.wx.store.sharer.common.exception.WeChatException;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;

import javax.servlet.http.HttpServletRequest;

/**
 * 全局异常处理器
 */
@Slf4j
@RestControllerAdvice
public class GlobalExceptionHandler {

    /**
     * 认证失败
     */
    @ExceptionHandler(NoAuthException.class)
    public Result<Void> handleNoAuthException(NoAuthException e, HttpServletRequest request) {
        String requestURI = request.getRequestURI();
        log.error("请求地址'{}',认证失败'{}',无法访问系统资源", requestURI, e.getMessage());
        return Result.fail(HttpStatusConstant.UNAUTHORIZED, "认证失败，无法访问系统资源");
    }

    /**
     * 系统异常
     */
    @ExceptionHandler(Exception.class)
    public Result<Void> handleException(Exception e, HttpServletRequest request) {
        String requestURI = request.getRequestURI();
        log.error("请求地址'{}',发生系统异常.", requestURI, e);
        return Result.fail(e);
    }

    /**
     * 业务异常-微信
     */
    @ExceptionHandler(WeChatException.class)
    public Result<Void> handleWeChatException(WeChatException e, HttpServletRequest request) {
        String requestURI = request.getRequestURI();
        log.error("请求地址'{}',微信业务异常.", requestURI, e);
        return Result.fail(e);
    }

    /**
     * 业务异常
     */
    @ExceptionHandler(BizException.class)
    public Result<Void> handleBizException(Exception e, HttpServletRequest request) {
        String requestURI = request.getRequestURI();
        log.error("请求地址'{}',发生业务异常.", requestURI, e);
        return Result.fail(e);
    }
}
