package com.netease.yanxuan.wx.store.sharer.integration.meta.model.bo;

import lombok.Builder;
import lombok.Data;

import java.io.Serializable;

/**
 * @Description 推客注册绑定信息-业务对象
 * @Author fanjiaxin
 * @Date 2025/3/11 18:43
 */
@Data
@Builder
public class WeChatSharerRegisterBindBO implements Serializable {
    private static final long serialVersionUID = 1996751915518651231L;

    /**
     * 推客在小程序中的 openid，和 sharer_appid 二选一
     */
    private String sharer_openid;
    /**
     * 推客在微信电商平台注册的身份标识，和 sharer_openid 二选一
     */
    private String sharer_appid;
    /**
     * 是否走简易版本注册【当走简易版本注册时，可以不要求推客开通商户号，但分佣只能走机构自己分佣；如果不走简易注册流程时，要求推客开通商户号作为收款账户，可以平台分佣】
     */
    private Boolean is_simple_register;
}
