package com.netease.yanxuan.wx.store.sharer.common.handler;

import lombok.RequiredArgsConstructor;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

import java.util.concurrent.TimeUnit;

/**
 * @Description redis客户端
 * @Author fanjiaxin
 * @Date 2025/3/10 10:32
 */
@Service
@RequiredArgsConstructor
public class RedisClient {

    private final RedisTemplate<String, Object> redisTemplate;

    public Object get(String key) {
        return redisTemplate.opsForValue().get(key);
    }

    public void set(String key, Object value) {
        redisTemplate.opsForValue().set(key, value);
    }

    public void set(String key, Object value, int expireSeconds) {
        redisTemplate.opsForValue().set(key, value, expireSeconds, TimeUnit.SECONDS);
    }

    public String getStr(String key) {
        Object value = redisTemplate.opsForValue().get(key);
        return null != value ? value.toString() : null;
    }

    public void setStr(String key, String value) {
        redisTemplate.opsForValue().set(key, value);
    }

    public void setStr(String key, String value, int expireSeconds) {
        redisTemplate.opsForValue().set(key, value, expireSeconds, TimeUnit.SECONDS);
    }

    public Boolean setIfAbsent(String key, Object value, int expireSeconds) {
        return redisTemplate.opsForValue().setIfAbsent(key, value, expireSeconds, TimeUnit.SECONDS);
    }

    public Boolean delete(String key) {
        return redisTemplate.delete(key);
    }
}