package com.netease.yanxuan.wx.store.sharer.biz.config;

import com.netease.yanxuan.wx.store.sharer.biz.interceptor.AuthInterceptor;
import com.netease.yanxuan.wx.store.sharer.biz.interceptor.UserInterceptor;
import lombok.RequiredArgsConstructor;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

import java.util.ArrayList;
import java.util.Collections;

/**
 * @Description 配置
 * @Author fanjiaxin
 * @Date 2025/3/10 10:54
 */
@Configuration
@RequiredArgsConstructor
public class WebConfig implements WebMvcConfigurer {
    private final AuthInterceptor authInterceptor;
    private final UserInterceptor userInterceptor;

    private static final String[] EXCLUDE_URLS = {"/i/health",
            "/sharer/open/**", "/sharer/test/**",
            "/sharer/user/login", "/sharer/product/page/list"};

    @Override
    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor(authInterceptor)
                .addPathPatterns("/**")
                .excludePathPatterns(getExcludePathPatterns());
        registry.addInterceptor(userInterceptor)
                .addPathPatterns("/**");
    }

    /**
     * 白名单
     */
    private ArrayList<String> getExcludePathPatterns() {
        ArrayList<String> list = new ArrayList<>();
        Collections.addAll(list, EXCLUDE_URLS);
        return list;
    }
}
