package com.netease.yanxuan.wx.store.sharer.integration.handler.impl;

import com.alibaba.fastjson.JSON;
import com.netease.yanxuan.wx.store.sharer.integration.config.WeChatConfig;
import com.netease.yanxuan.wx.store.sharer.integration.constant.WeChatApi;
import com.netease.yanxuan.wx.store.sharer.integration.core.WeChatContextHolder;
import com.netease.yanxuan.wx.store.sharer.integration.handler.IWeChatRequest;
import com.netease.yanxuan.wx.store.sharer.integration.handler.WeChatRestTemplateHandler;
import com.netease.yanxuan.wx.store.sharer.integration.meta.enums.ProductPlanTypeEnum;
import com.netease.yanxuan.wx.store.sharer.integration.meta.model.bo.WeChatPromoteProductListBO;
import com.netease.yanxuan.wx.store.sharer.integration.meta.model.vo.WeChatPromoteProductListVO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Service;

/**
 * @Description 商品列表
 * @Author fanjiaxin
 * @Date 2025/3/11 17:33
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class WeChatShopPromoteProductListRequest implements IWeChatRequest {
    private final WeChatContextHolder weChatContextHolder;
    private final WeChatRestTemplateHandler weChatRestTemplateHandler;
    private final WeChatConfig weChatConfig;


    @Override
    public HttpMethod getRequestMethod() {
        return HttpMethod.POST;
    }

    @Override
    public String getRequestUrl() {
        return weChatConfig.getUrl() + WeChatApi.GET_PROMOTE_PRODUCT_LIST
                + "?" + WeChatApi.WECHAT_REQUEST_TOKEN_FIELD_NAME + "="
                + weChatContextHolder.getShopAccessToken();
    }

    /**
     * 处理
     */
    public WeChatPromoteProductListVO handle(String keyword, String nextKey, Integer pageSize) {
        WeChatPromoteProductListBO params = WeChatPromoteProductListBO.builder()
                .plan_type(ProductPlanTypeEnum.OPEN.getCode())
                .keyword(keyword)
                .next_key(nextKey)
                .page_size(pageSize)
                .build();
        return weChatRestTemplateHandler.execute(getRequestUrl(), getRequestMethod(), params, WeChatPromoteProductListVO.class);
    }


    public static void main(String[] args) {
        String resultJson = "{\n" +
                "    \"errcode\": 0,\n" +
                "    \"errmsg\": \"ok\",\n" +
                "    \"product_list\": [\n" +
                "        {\n" +
                "            \"product_id\": \"10000032169520\",\n" +
                "            \"shop_appid\": \"wxdad237db7677c305\"\n" +
                "        },\n" +
                "        {\n" +
                "            \"product_id\": \"10000157865162\",\n" +
                "            \"shop_appid\": \"wx015b4279a9e8f6fa\"\n" +
                "        },\n" +
                "        {\n" +
                "            \"product_id\": \"10000018293357\",\n" +
                "            \"shop_appid\": \"wxe0aa3c442f854635\"\n" +
                "        },\n" +
                "        {\n" +
                "            \"product_id\": \"10000129786349\",\n" +
                "            \"shop_appid\": \"wx55ea53cbc4855c21\"\n" +
                "        },\n" +
                "        {\n" +
                "            \"product_id\": \"10000168454112\",\n" +
                "            \"shop_appid\": \"wxf69920284f28bbe3\"\n" +
                "        },\n" +
                "        {\n" +
                "            \"product_id\": \"10000029788412\",\n" +
                "            \"shop_appid\": \"wx31f74421a0acf076\"\n" +
                "        },\n" +
                "        {\n" +
                "            \"product_id\": \"10000143496444\",\n" +
                "            \"shop_appid\": \"wx15aa8d178f9946ca\"\n" +
                "        },\n" +
                "        {\n" +
                "            \"product_id\": \"10000134193908\",\n" +
                "            \"shop_appid\": \"wx2e8388eeeea714de\"\n" +
                "        },\n" +
                "        {\n" +
                "            \"product_id\": \"10000144234386\",\n" +
                "            \"shop_appid\": \"wxd4c232e8fe49f909\"\n" +
                "        },\n" +
                "        {\n" +
                "            \"product_id\": \"10000076193764\",\n" +
                "            \"shop_appid\": \"wx66b0a1ddf47badf0\"\n" +
                "        }\n" +
                "    ],\n" +
                "    \"next_key\": \"CAoQChoWChQxMDAwMDAzMjk3MjY4MzM3NDMzMw==\"\n" +
                "}";
        WeChatPromoteProductListVO productListVO = JSON.parseObject(resultJson, WeChatPromoteProductListVO.class);
        System.err.println(JSON.toJSONString(productListVO));
    }
}
