package com.netease.yanxuan.wx.store.sharer.integration.handler;

import com.alibaba.fastjson.JSON;
import com.netease.yanxuan.wx.store.sharer.common.exception.WeChatException;
import com.netease.yanxuan.wx.store.sharer.common.handler.RestTemplateClient;
import com.netease.yanxuan.wx.store.sharer.integration.constant.WeChatApi;
import com.netease.yanxuan.wx.store.sharer.integration.meta.model.vo.WeChatCoreVO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Service;

/**
 * @Description RestTemplateClient
 * @Author fanjiaxin
 * @Date 2025/3/11 17:27
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class WeChatRestTemplateHandler {
    private final RestTemplateClient restTemplateClient;

    public <T, R extends WeChatCoreVO> R execute(String url, HttpMethod method, T params, Class<R> resType) {
        R result;
        try {
            String resultJson = restTemplateClient.execute(url, method, params);
            result = JSON.parseObject(resultJson, resType);
        } catch (Exception e) {
            throw new WeChatException(e);
        }
        if (StringUtils.isNotBlank(result.getErrcode())
                && !WeChatApi.WECHAT_REQUEST_SUCCESS_CODE.equals(result.getErrcode())) {
            throw new WeChatException("调用微信接口失败，" + result.getErrmsg());
        }
        return result;
    }
}

