package com.netease.yanxuan.wx.store.sharer.integration.task;

import com.netease.yanxuan.wx.store.sharer.integration.core.WeChatContextHolder;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.CommandLineRunner;
import org.springframework.stereotype.Component;

/**
 * @Description 微信小店认证信息初始化
 * @Date 2025/3/13 11:57
 */
@Slf4j
@RequiredArgsConstructor
@Component
public class WeChatShopAuthTask implements CommandLineRunner {
    private final WeChatContextHolder weChatContextHolder;


    @Override
    public void run(String... args) {
        log.info("微信小店认证信息初始化开始...");
        try {
            weChatContextHolder.createShopAccessToken();
            log.info("微信小店认证信息初始化完成");
        } catch (Exception e) {
            log.error("微信小店认证信息初始化失败", e);
        }
    }
}
