package com.netease.yanxuan.wx.store.sharer.integration.handler.impl;

import com.netease.yanxuan.wx.store.sharer.integration.config.WeChatConfig;
import com.netease.yanxuan.wx.store.sharer.integration.constant.WeChatApi;
import com.netease.yanxuan.wx.store.sharer.integration.handler.IWeChatRequest;
import com.netease.yanxuan.wx.store.sharer.integration.handler.WeChatRestTemplateHandler;
import com.netease.yanxuan.wx.store.sharer.integration.meta.model.bo.WeChatSetSharerProductCommissionBO;
import com.netease.yanxuan.wx.store.sharer.integration.meta.model.vo.WeChatCoreVO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Service;

/**
 * @Description 设置推客的单个商品的分佣比例信息
 * @Author fanjiaxin
 * @Date 2025/3/11 17:33
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class WeChatSetSharerProductCommissionRequest implements IWeChatRequest {
    private final WeChatRestTemplateHandler weChatRestTemplateHandler;
    private final WeChatConfig weChatConfig;


    @Override
    public HttpMethod getRequestMethod() {
        return HttpMethod.POST;
    }

    @Override
    public String getRequestUrl() {
        return weChatConfig.getUrl() + WeChatApi.SET_SHARER_PRODUCT_COMMISSION_INFO + "?access_token=" + getAccessToken();
    }

    /**
     * 处理
     */
    public WeChatCoreVO handle(String sharerAppid, Integer productId, String commissionRatio) {
        WeChatSetSharerProductCommissionBO params = WeChatSetSharerProductCommissionBO.builder()
                .sharer_appid(sharerAppid)
                .product_id(productId)
                .commission_ratio(commissionRatio)
                .build();
        return weChatRestTemplateHandler.execute(getRequestUrl(), getRequestMethod(), params, WeChatCoreVO.class);
    }
}
