/**
 * @(#)TestController.java, 2025/3/10.
 * <p/>
 * Copyright 2025 Netease, Inc. All rights reserved.
 * NETEASE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.netease.yanxuan.wx.store.sharer.web.controller;

import com.netease.yanxuan.wx.store.sharer.biz.meta.model.bo.RealNameAuthenticatedBO;
import com.netease.yanxuan.wx.store.sharer.biz.meta.model.bo.SmsCodeBO;
import com.netease.yanxuan.wx.store.sharer.biz.service.ICommissionOrderService;
import com.netease.yanxuan.wx.store.sharer.biz.service.ISmsService;
import com.netease.yanxuan.wx.store.sharer.common.core.Result;
import com.netease.yanxuan.wx.store.sharer.common.exception.BizException;
import com.netease.yanxuan.wx.store.sharer.integration.client.IUserInfoClient;
import lombok.RequiredArgsConstructor;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

/**
 * @author 刘运星 (liuyunxing01@corp.netease.com)
 */
@RestController
@RequestMapping("/sharer/test")
@RequiredArgsConstructor
public class TestController {
    private final ICommissionOrderService iCommissionOrderService;
    private final IUserInfoClient iUserInfoClient;
    private final ISmsService iSmsService;

    /**
     * 同步订单
     */
    @GetMapping("/syncCommissionOrder")
    public Result<Void> syncCommissionOrder(@RequestParam("startTime") Long startTime,
                                            @RequestParam("endTime") Long endTime) {
        iCommissionOrderService.doCommissionOrderSync(startTime, endTime);
        return Result.ok();
    }

    /**
     * 同步订单重试
     */
    @GetMapping("/doCommissionOrderFailRetry")
    public Result<Void> doCommissionOrderFailRetry() {
        iCommissionOrderService.doCommissionOrderFailRetry();
        return Result.ok();
    }

    /**
     * 发送短信验证码
     */
    @PostMapping("/sendSmsCode")
    public Result<Boolean> sendSmsCode(@Validated @RequestBody SmsCodeBO bo) {
        iSmsService.sendSmsCode(bo);
        return Result.ok(true);
    }

    /**
     * 实名认证
     */
    @PostMapping("/verifyByIdentityNo")
    public Result<Boolean> verifyByIdentityNo(@RequestBody RealNameAuthenticatedBO bo) {
        Boolean isVerifySuccess = iUserInfoClient.verifyByIdentityNo(bo.getUsername(), bo.getIdCardNumber());
        if (null == isVerifySuccess || !isVerifySuccess) {
            throw new BizException("实名认证不通过");
        }
        return Result.ok(true);
    }
}