package com.netease.yanxuan.wx.store.sharer.common.handler;

import org.springframework.http.HttpMethod;

/**
 * @Description HTTP请求
 * @Author fanjiaxin
 * @Date 2025/3/11 17:27
 */
public interface HttpRequestClient {
    /**
     * 执行 HTTP 请求
     *
     * @param url     请求地址
     * @param method  请求类型 (GET/POST)
     * @param params  请求参数 (GET 对应查询参数，POST 对应表单/JSON 参数)
     * @return 响应结果
     */
    <T> String execute(String url, HttpMethod method, T params);
}
