package com.netease.yanxuan.wx.store.sharer.biz.service.impl;

import com.netease.yanxuan.wx.store.sharer.biz.config.DrmSharerConfig;
import com.netease.yanxuan.wx.store.sharer.biz.core.LoginUserContextHolder;
import com.netease.yanxuan.wx.store.sharer.biz.core.LoginUserInfo;
import com.netease.yanxuan.wx.store.sharer.biz.meta.model.vo.ProductListVO;
import com.netease.yanxuan.wx.store.sharer.biz.meta.page.PageQuery;
import com.netease.yanxuan.wx.store.sharer.biz.meta.page.PageVO;
import com.netease.yanxuan.wx.store.sharer.biz.service.IProductService;
import com.netease.yanxuan.wx.store.sharer.integration.handler.impl.WeChatShopPromoteProductDetailRequest;
import com.netease.yanxuan.wx.store.sharer.integration.handler.impl.WeChatShopPromoteProductLinkRequest;
import com.netease.yanxuan.wx.store.sharer.integration.handler.impl.WeChatShopPromoteProductListRequest;
import com.netease.yanxuan.wx.store.sharer.integration.handler.impl.WeChatShopSharerListRequest;
import com.netease.yanxuan.wx.store.sharer.integration.meta.model.vo.*;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

/**
 * @Description 商品-业务实现类
 * @Author fanjiaxin
 * @Date 2025/3/10 12:31
 */
@Slf4j
@RequiredArgsConstructor
@Service
public class ProductServiceImpl implements IProductService {
    private final WeChatShopPromoteProductListRequest weChatShopPromoteProductListRequest;
    private final WeChatShopPromoteProductDetailRequest weChatShopPromoteProductDetailRequest;
    private final WeChatShopPromoteProductLinkRequest weChatShopPromoteProductLinkRequest;
    private final WeChatShopSharerListRequest weChatShopSharerListRequest;
    private final DrmSharerConfig drmSharerConfig;

    @Override
    public PageVO<ProductListVO> getProductPageList(PageQuery pageQuery, String keyword) {
        PageVO<ProductListVO> pageVO = new PageVO<>();
        WeChatPromoteProductListVO productListVO = weChatShopPromoteProductListRequest.handle(keyword,
                pageQuery.getNextKey(), pageQuery.getPageSize());
        pageVO.setHasMore(!CollectionUtils.isEmpty(productListVO.getProduct_list())
                && productListVO.getProduct_list().size() >= pageQuery.getPageSize());
        pageVO.setNextKey(productListVO.getNext_key());
        // 商品列表
        List<ProductListVO> resultList = Optional.ofNullable(productListVO.getProduct_list()).orElseGet(ArrayList::new)
                .stream()
                .map(item -> {
                    WeChatPromoteProductDetailVO detailVO = weChatShopPromoteProductDetailRequest.handle(item.getShop_appid(),
                            item.getProduct_id());
                    if(null == detailVO){
                        return null;
                    }
                    WeChatPromoteProductDetailVO.WeChatPromoteProductVO product = detailVO.getProduct();
                    if(null == product){
                        return null;
                    }
                    WeChatPromoteProductDetailVO.WeChatPromoteProductVO.WeChatPromoteProductInfoVO productInfo = product.getProduct_info();
                    if(null == productInfo){
                        return null;
                    }
                    ProductListVO listVO = new ProductListVO();
                    listVO.setTitle(productInfo.getTitle());
                    listVO.setHeadImg(CollectionUtils.isEmpty(productInfo.getHead_imgs()) ? null : productInfo.getHead_imgs().get(0));
                    // 取参数SkuInfo中sale_price的最小
                    BigDecimal price = Optional.ofNullable(productInfo.getSkus()).orElseGet(ArrayList::new)
                            .stream()
                            .map(WeChatPromoteProductDetailVO.WeChatPromoteProductVO.WeChatPromoteProductInfoVO.WeChatPromoteProductSkuInfoVO::getSale_price)
                            .min(BigDecimal::compareTo).orElse(null);
                    listVO.setPrice(price);

                    // 推客分佣比例
                    BigDecimal commissionRatio = drmSharerConfig.getDefaultCommissionRatio();
                    // 获取用户信息
                    LoginUserInfo loginUserInfo = LoginUserContextHolder.get();
                    if(null != loginUserInfo && StringUtils.isNotBlank(loginUserInfo.getOpenId())){
                        WeChatSharerListVO sharerListVO = weChatShopSharerListRequest.handle(loginUserInfo.getOpenId(), "", 1);
                        if (null != sharerListVO && !CollectionUtils.isEmpty(sharerListVO.getSharer_info_list())) {
                            WeChatSharerInfoVO sharerInfoVO = sharerListVO.getSharer_info_list().get(0);
                            if (null != sharerInfoVO && null != sharerInfoVO.getCommission_ratio()) {
                                commissionRatio = sharerInfoVO.getCommission_ratio();
                            }
                        }
                    }
                    WeChatPromoteProductDetailVO.WeChatPromoteProductVO.WeChatPromoteProductCommissionInfoVO commissionInfo = product.getCommission_info();
                    // 服务费率
                    Integer serviceRatio = null != commissionInfo ? commissionInfo.getService_ratio() : null;
                    // 佣金=商品价格*服务费率*推客分佣比例，四舍五入保留小数点后两位
                    BigDecimal commission = null;
                    if(null != price && null != commissionRatio && null != serviceRatio){
                        commission = price.multiply(new BigDecimal(serviceRatio.toString()))
                                .multiply(commissionRatio).setScale(2, RoundingMode.HALF_UP);
                    }
                    listVO.setCommission(commission);
                    listVO.setShopAppid(item.getShop_appid());
                    listVO.setProductId(item.getProduct_id());
                    // 获取推广链接
                    WeChatPromoteProductLinkVO promoteProductLinkVO = weChatShopPromoteProductLinkRequest.handle(item.getShop_appid(), item.getProduct_id());
                    listVO.setProductUrl(null != promoteProductLinkVO ? promoteProductLinkVO.getShort_link() : null);
                    return listVO;
                })
                .filter(Objects::nonNull)
                .collect(Collectors.toList());
        pageVO.setList(resultList);
        return pageVO;
    }
}
