package com.netease.yanxuan.wx.store.sharer.integration.meta.model.vo;

import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

/**
 * @Description 商品详情-视图对象
 * @Author fanjiaxin
 * @Date 2025/3/11 19:05
 */
@Data
public class WeChatPromoteProductDetailVO extends WeChatCoreVO {
    private static final long serialVersionUID = 8529644543147459802L;

    /**
     * 商品信息
     */
    private WeChatPromoteProductVO product;


    @Data
    public static class WeChatPromoteProductVO {
        /**
         * 所属小店appid
         */
        private String shop_appid;
        /**
         * 商品id
         */
        private String product_id;
        /**
         * 商品卡片透传参数【注意：内嵌商品卡片时一定要传，不然会归因失败】
         */
        private String product_promotion_link;
        /**
         * 商品信息，结构体详情请参考ProductInfo
         */
        private WeChatPromoteProductInfoVO product_info;
        /**
         * 跟佣信息
         */
        private WeChatPromoteProductCommissionInfoVO commission_info;

        @Data
        public static class WeChatPromoteProductInfoVO {
            /**
             * 标题
             */
            private String title;
            /**
             * 副标题。如果添加时没录入，回包可能不包含该字段
             */
            private String sub_title;
            /**
             * 主图,多张,列表,最多9张,每张不超过2MB
             */
            private List<String> head_imgs;
            /**
             * 用于在小程序跳转小店场景添加商品时传递跟佣信息
             */
            private String product_promotion_link;
            /**
             * sku信息
             */
            private List<WeChatPromoteProductSkuInfoVO> skus;


            @Data
            public static class WeChatPromoteProductSkuInfoVO {
                /**
                 * skuID
                 */
                private String sku_id;
                /**
                 * 售卖价格，以分为单位
                 */
                private BigDecimal sale_price;
                /**
                 * 库存
                 */
                private Integer stock_num;
            }
        }

        @Data
        public static class WeChatPromoteProductCommissionInfoVO {
            /**
             * 商品带货状态 ，枚举值详情请参考ItemStatus
             */
            private Integer status;
            /**
             * 服务费率[0, 1000000]
             */
            private Integer service_ratio;
            /**
             * 时间戳，合作开始时间
             */
            private Long start_time;
            /**
             * 时间戳，合作结束时间
             */
            private Long end_time;
        }
    }
}
