package com.netease.yanxuan.wx.store.sharer.biz.config;

import com.alibaba.fastjson.JSON;
import com.ctrip.framework.apollo.model.ConfigChange;
import com.ctrip.framework.apollo.model.ConfigChangeEvent;
import com.ctrip.framework.apollo.spring.annotation.ApolloConfigChangeListener;
import com.ctrip.framework.apollo.spring.annotation.EnableAutoUpdateApolloConfig;
import com.ctrip.framework.apollo.spring.annotation.ValueMapping;
import com.netease.yanxuan.wx.store.sharer.biz.core.LoginUserContextHolder;
import com.netease.yanxuan.wx.store.sharer.biz.core.LoginUserInfo;
import com.netease.yanxuan.wx.store.sharer.biz.meta.enums.CommissionChangeOptTypeEnum;
import com.netease.yanxuan.wx.store.sharer.biz.meta.model.bo.ProductCommissionSharerBO;
import com.netease.yanxuan.wx.store.sharer.biz.meta.model.bo.ProductCommissionSharerProductBO;
import com.netease.yanxuan.wx.store.sharer.dal.mapper.SharerProductCommissionRecordMapper;
import com.netease.yanxuan.wx.store.sharer.dal.meta.model.po.SharerProductCommissionRecord;
import lombok.Data;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @Description 商品分佣金配置
 * @Author fanjiaxin
 * @Date 2025/3/10 17:26
 */
@Slf4j
@Data
@Component
@RequiredArgsConstructor
@EnableAutoUpdateApolloConfig
public class ProductCommissionConfig {
    private final SharerProductCommissionRecordMapper sharerProdutcCommissionRecordMapper;

    /**
     * 默认分佣比例
     */
    @Value("${application.commissionratio.default:10}")
    private BigDecimal defaultCommissionRatio;
    /**
     * 用户分佣比例
     */
    @ValueMapping("${application.commissionratio.sharer:}")
    private ProductCommissionSharerBO productCommissionSharerBO;
    /**
     * 用户商品分佣比例
     */
    @ValueMapping("${application.commissionratio.sharerproduct:}")
    private ProductCommissionSharerProductBO productCommissionSharerProductBO;

    /**
     * 监听
     */
    @ApolloConfigChangeListener("sv-channel.config")
    public void onChange(ConfigChangeEvent changeEvent) {
        log.info("ProductCommissionConfig:onChange, changeEvent = {}", JSON.toJSONString(changeEvent));

        // 默认分佣比例
        String defaultCommissionratio = "application.commissionratio.default";
        if (changeEvent.isChanged(defaultCommissionratio)) {
            ConfigChange change = changeEvent.getChange(defaultCommissionratio);
            defaultCommissionratioChange(change);
        }

        // 用户分佣比例
        String sharerCommissionratio = "application.commissionratio.sharer";
        if (changeEvent.isChanged(sharerCommissionratio)) {
            ConfigChange change = changeEvent.getChange(sharerCommissionratio);
            sharerCommissionratioChange(change);
        }

        // 用户商品分佣比例
        String sharerproductCommissionratio = "application.commissionratio.sharerproduct";
        if (changeEvent.isChanged(sharerproductCommissionratio)) {
            ConfigChange change = changeEvent.getChange(sharerproductCommissionratio);
            sharerproductCommissionratioChange(change);
        }
    }

    /**
     * 默认分佣比例变更
     */
    private void defaultCommissionratioChange(ConfigChange change){
        LoginUserInfo loginUserInfo = LoginUserContextHolder.get();
        if (null == loginUserInfo) {
            log.error("用户登录状态过期");
            return;
        }
        SharerProductCommissionRecord record = new SharerProductCommissionRecord();
        record.setOpenId(loginUserInfo.getOpenId());
        record.setSharerAppid(loginUserInfo.getSharerAppId());
        record.setProductId("");
        record.setOptType(CommissionChangeOptTypeEnum.DEFAULT_CHANGE.getCode());
        record.setOptInfo(change.getOldValue() + "&" + change.getNewValue());
        record.setOptTime(new Date());
        record.setOptStatus("1");
        record.setExtInfo("");
        record.setCreateTime(new Date());
        record.setUpdateTime(new Date());
        sharerProdutcCommissionRecordMapper.insert(record);
    }

    /**
     * 用户分佣比例变更
     */
    private void sharerCommissionratioChange(ConfigChange change){
        LoginUserInfo loginUserInfo = LoginUserContextHolder.get();
        if (null == loginUserInfo) {
            log.error("用户登录状态过期");
            return;
        }
        SharerProductCommissionRecord record = new SharerProductCommissionRecord();
        record.setOpenId(loginUserInfo.getOpenId());
        record.setSharerAppid(loginUserInfo.getSharerAppId());
        record.setProductId("");
        record.setOptType(CommissionChangeOptTypeEnum.SET.getCode());
        record.setOptInfo(change.getOldValue() + "&" + change.getNewValue());
        record.setOptTime(new Date());
        record.setOptStatus("1");
        record.setExtInfo("");
        record.setCreateTime(new Date());
        record.setUpdateTime(new Date());
        sharerProdutcCommissionRecordMapper.insert(record);
    }

    /**
     * 用户商品分佣比例变更
     */
    private void sharerproductCommissionratioChange(ConfigChange change){
        LoginUserInfo loginUserInfo = LoginUserContextHolder.get();
        if (null == loginUserInfo) {
            log.error("用户登录状态过期");
            return;
        }
        SharerProductCommissionRecord record = new SharerProductCommissionRecord();
        record.setOpenId(loginUserInfo.getOpenId());
        record.setSharerAppid(loginUserInfo.getSharerAppId());
        record.setProductId("");
        record.setOptType(CommissionChangeOptTypeEnum.SET.getCode());
        record.setOptInfo(change.getOldValue() + "&" + change.getNewValue());
        record.setOptTime(new Date());
        record.setOptStatus("1");
        record.setExtInfo("");
        record.setCreateTime(new Date());
        record.setUpdateTime(new Date());
        sharerProdutcCommissionRecordMapper.insert(record);
    }
}