package com.netease.yanxuan.wx.store.sharer.biz.service.impl;

import cn.dev33.satoken.stp.StpUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.netease.yanxuan.wx.store.sharer.biz.config.ProductCommissionConfig;
import com.netease.yanxuan.wx.store.sharer.biz.core.LoginUserContextHolder;
import com.netease.yanxuan.wx.store.sharer.biz.core.LoginUserHelper;
import com.netease.yanxuan.wx.store.sharer.biz.core.LoginUserInfo;
import com.netease.yanxuan.wx.store.sharer.biz.meta.model.bo.LoginBO;
import com.netease.yanxuan.wx.store.sharer.biz.meta.model.vo.SharerInfoVO;
import com.netease.yanxuan.wx.store.sharer.biz.meta.model.vo.UserCommissionRatioVO;
import com.netease.yanxuan.wx.store.sharer.biz.meta.model.vo.UserTokenVO;
import com.netease.yanxuan.wx.store.sharer.biz.service.IUserService;
import com.netease.yanxuan.wx.store.sharer.common.exception.NoAuthException;
import com.netease.yanxuan.wx.store.sharer.dal.mapper.SharerInfoMapper;
import com.netease.yanxuan.wx.store.sharer.dal.meta.model.po.SharerInfo;
import com.netease.yanxuan.wx.store.sharer.integration.handler.impl.WeChatSharerListRequest;
import com.netease.yanxuan.wx.store.sharer.integration.handler.impl.WeChatSharerRegisterBindRequest;
import com.netease.yanxuan.wx.store.sharer.integration.handler.impl.WeChatUserInfoRequest;
import com.netease.yanxuan.wx.store.sharer.integration.meta.model.vo.WeChatSharerInfoVO;
import com.netease.yanxuan.wx.store.sharer.integration.meta.model.vo.WeChatSharerListVO;
import com.netease.yanxuan.wx.store.sharer.integration.meta.model.vo.WeChatSharerRegisterBindVO;
import com.netease.yanxuan.wx.store.sharer.integration.meta.model.vo.WeChatUserInfoVO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @Description 用户-业务实现类
 * @Author fanjiaxin
 * @Date 2025/3/10 12:31
 */
@Slf4j
@RequiredArgsConstructor
@Service
public class UserServiceImpl implements IUserService {

    private final SharerInfoMapper sharerInfoMapper;
    private final ProductCommissionConfig productCommissionConfig;
    private final LoginUserHelper jwtHelper;
    private final WeChatUserInfoRequest weChatUserRequest;
    private final WeChatSharerRegisterBindRequest weChatSharerRegisterBindRequest;
    private final WeChatSharerListRequest weChatSharerListRequest;


    @Override
    public UserTokenVO login(LoginBO bo) {
        Date now = new Date();
        // 获取用户信息
        WeChatUserInfoVO userInfoVO = weChatUserRequest.handle(bo.getCode());
        // 获取本地用户信息
        LambdaQueryWrapper<SharerInfo> sharerInfoLqw = Wrappers.lambdaQuery();
        sharerInfoLqw.eq(SharerInfo::getOpenId, userInfoVO.getOpenid());
        sharerInfoLqw.last("LIMIT 1");
        SharerInfo sharerInfo = sharerInfoMapper.selectOne(sharerInfoLqw);
        if (null == sharerInfo) {
            sharerInfo = new SharerInfo();
            sharerInfo.setOpenId(userInfoVO.getOpenid());
            // 默认佣金比例
            sharerInfo.setCommissionRatio(new BigDecimal(10));
            sharerInfo.setCommissionType("1");
            sharerInfo.setCreateTime(now);
            sharerInfo.setUpdateTime(now);
            sharerInfoMapper.insert(sharerInfo);
        }
        // 生成token
        String token = StpUtil.getTokenValue();
        LoginUserInfo loginUserInfo = new LoginUserInfo();
        loginUserInfo.setAccessToken(token);
        loginUserInfo.setOpenId(sharerInfo.getOpenId());
        loginUserInfo.setSharerAppId(null);
        jwtHelper.setLoginUserInfo(token, loginUserInfo);
        return UserTokenVO.builder().token(token).build();
    }

    @Override
    public SharerInfoVO refreshUserInfo() {
        LoginUserInfo loginUserInfo = LoginUserContextHolder.get();
        if (null == loginUserInfo) {
            throw new NoAuthException("用户登录状态过期");
        }
        SharerInfoVO result = getSharerRegisterBindInfo(loginUserInfo.getOpenId());
        // 获取本地用户信息
        LambdaQueryWrapper<SharerInfo> sharerInfoLqw = Wrappers.lambdaQuery();
        sharerInfoLqw.eq(SharerInfo::getOpenId, loginUserInfo.getOpenId());
        sharerInfoLqw.last("LIMIT 1");
        SharerInfo sharerInfo = sharerInfoMapper.selectOne(sharerInfoLqw);
        Date now = new Date();
        // 初始化保存
        if (null == sharerInfo) {
            sharerInfo = new SharerInfo();
            sharerInfo.setOpenId(loginUserInfo.getOpenId());
            // 默认佣金比例
            sharerInfo.setCommissionRatio(new BigDecimal(10));
            sharerInfo.setCommissionType("1");
            sharerInfo.setCreateTime(now);
            sharerInfo.setUpdateTime(now);
            sharerInfoMapper.insert(sharerInfo);
        }
        // 已经绑定
        if (StringUtils.isNotBlank(sharerInfo.getSharerAppid())) {
            result.setSharerAppId(sharerInfo.getSharerAppid());
        }
        WeChatSharerListVO sharerListVO = weChatSharerListRequest.handle(loginUserInfo.getOpenId(), "", 1);
        if (null != sharerListVO && !CollectionUtils.isEmpty(sharerListVO.getSharer_info_list())) {
            WeChatSharerInfoVO sharerInfoVO = sharerListVO.getSharer_info_list().get(0);
            if (null != sharerInfoVO && StringUtils.isNotBlank(sharerInfoVO.getSharer_appid())) {
                result.setSharerAppId(sharerInfoVO.getSharer_appid());
                sharerInfo.setSharerAppid(sharerInfoVO.getSharer_appid());
                sharerInfo.setBindTime(new Date(sharerInfoVO.getBind_time()));
                sharerInfo.setCommissionRatio(new BigDecimal(10));
                sharerInfo.setCommissionType("1");
                sharerInfo.setUpdateTime(now);
                sharerInfoMapper.updateById(sharerInfo);
            }
        }
        return result;
    }

    @Override
    public SharerInfoVO getUserInfo() {
        LoginUserInfo loginUserInfo = LoginUserContextHolder.get();
        if (null == loginUserInfo) {
            throw new NoAuthException("用户登录状态过期");
        }
        SharerInfoVO result = getSharerRegisterBindInfo(loginUserInfo.getOpenId());
        // 获取本地用户信息
        LambdaQueryWrapper<SharerInfo> sharerInfoLqw = Wrappers.lambdaQuery();
        sharerInfoLqw.eq(SharerInfo::getOpenId, loginUserInfo.getOpenId());
        sharerInfoLqw.last("LIMIT 1");
        SharerInfo sharerInfo = sharerInfoMapper.selectOne(sharerInfoLqw);
        // 已经绑定
        if (null != sharerInfo && StringUtils.isNotBlank(sharerInfo.getSharerAppid())) {
            result.setSharerAppId(sharerInfo.getSharerAppid());
        }
        return result;
    }

    @Override
    public UserCommissionRatioVO getCommissionRatioDefault() {
        BigDecimal defaultCommissionRatio = productCommissionConfig.getDefaultCommissionRatio();
        return UserCommissionRatioVO.builder().commissionRatio(defaultCommissionRatio).build();
    }

    private SharerInfoVO getSharerRegisterBindInfo(String openId) {
        // 获取推客注册与绑定信息
        WeChatSharerRegisterBindVO sharerRegisterBindVO = weChatSharerRegisterBindRequest.handle(openId);
        SharerInfoVO result = new SharerInfoVO();
        result.setOpenId(openId);
        result.setBindStatus(sharerRegisterBindVO.getBind_status());
        result.setRegisterStatus(sharerRegisterBindVO.getRegister_status());
        result.setRegisterBusinessType(sharerRegisterBindVO.getRegister_business_type());
        result.setRegisterQueryString(sharerRegisterBindVO.getRegister_query_string());
        result.setBindBusinessType(sharerRegisterBindVO.getBind_business_type());
        result.setBindQueryString(sharerRegisterBindVO.getBind_query_string());
        return result;
    }
}
