package com.netease.yanxuan.wx.store.sharer.integration.handler.impl;

import com.netease.yanxuan.wx.store.sharer.integration.config.WeChatConfig;
import com.netease.yanxuan.wx.store.sharer.integration.constant.WeChatApi;
import com.netease.yanxuan.wx.store.sharer.integration.handler.IWeChatRequest;
import com.netease.yanxuan.wx.store.sharer.integration.handler.WeChatRestTemplateHandler;
import com.netease.yanxuan.wx.store.sharer.integration.meta.enums.ProductPlanTypeEnum;
import com.netease.yanxuan.wx.store.sharer.integration.meta.model.bo.WeChatPromoteProductDetailBO;
import com.netease.yanxuan.wx.store.sharer.integration.meta.model.vo.WeChatPromoteProductDetailVO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Service;

/**
 * @Description 商品详情
 * @Author fanjiaxin
 * @Date 2025/3/11 17:33
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class WeChatPromoteProductDetailRequest implements IWeChatRequest {
    private final WeChatRestTemplateHandler weChatRestTemplateHandler;
    private final WeChatConfig weChatConfig;


    @Override
    public HttpMethod getRequestMethod() {
        return HttpMethod.POST;
    }

    @Override
    public String getRequestUrl() {
        return weChatConfig.getUrl() + WeChatApi.GET_PROMOTE_PRODUCT_DETAIL;
    }

    /**
     * 处理
     */
    public WeChatPromoteProductDetailVO handle(String shopAppid, Integer productId) {
        WeChatPromoteProductDetailBO params = WeChatPromoteProductDetailBO.builder()
                .plan_type(ProductPlanTypeEnum.OPEN.getCode())
                .shop_appid(shopAppid)
                .product_id(productId)
                .build();
        return weChatRestTemplateHandler.execute(getRequestUrl(), getRequestMethod(), params, WeChatPromoteProductDetailVO.class);
    }
}
