package com.netease.yanxuan.wx.store.sharer.integration.config;

import com.ctrip.framework.apollo.spring.annotation.EnableAutoUpdateApolloConfig;
import com.ctrip.framework.apollo.spring.annotation.ValueMapping;
import com.netease.yanxuan.wx.store.sharer.integration.meta.model.bo.SmsCodeScenesConfigBO;
import lombok.Data;
import org.springframework.stereotype.Component;

import java.util.Map;

/**
 * @Description 应用配置
 * @Author fanjiaxin
 * @Date 2025/3/10 17:26
 */
@Data
@Component
@EnableAutoUpdateApolloConfig
public class SmsConfig {
    /**
     * 场景验证码配置
     * key: 业务场景标识
     */
    @ValueMapping("${sms.scenes.config.map:{}}")
    private Map<String, SmsCodeScenesConfigBO> scenesConfigMap;


    public SmsCodeScenesConfigBO getScenesConfig(String scenes) {
        return scenesConfigMap.get(scenes);
    }
}