package com.netease.yanxuan.wx.store.sharer.integration.handler.impl;

import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Service;

import com.alibaba.fastjson.JSONObject;
import com.netease.yanxuan.wx.store.sharer.integration.config.WeChatConfig;
import com.netease.yanxuan.wx.store.sharer.integration.constant.WeChatApi;
import com.netease.yanxuan.wx.store.sharer.integration.core.WeChatContextHolder;
import com.netease.yanxuan.wx.store.sharer.integration.handler.IWeChatRequest;
import com.netease.yanxuan.wx.store.sharer.integration.handler.WeChatRestTemplateHandler;
import com.netease.yanxuan.wx.store.sharer.integration.meta.enums.CommissionTypeEnum;
import com.netease.yanxuan.wx.store.sharer.integration.meta.model.bo.WeChatSetSharerCommissionBO;
import com.netease.yanxuan.wx.store.sharer.integration.meta.model.vo.WeChatCoreVO;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;

/**
 * @Description 设置推客的分佣比例信息
 * @Author fanjiaxin
 * @Date 2025/3/11 17:33
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class WeChatShopSetSharerCommissionRequest implements IWeChatRequest {
    private final WeChatContextHolder weChatContextHolder;
    private final WeChatRestTemplateHandler weChatRestTemplateHandler;
    private final WeChatConfig weChatConfig;


    @Override
    public HttpMethod getRequestMethod() {
        return HttpMethod.POST;
    }

    @Override
    public String getRequestUrl() {
        return weChatConfig.getUrl() + WeChatApi.SET_SHARER_COMMISSION_INFO
                + "?" + WeChatApi.WECHAT_REQUEST_TOKEN_FIELD_NAME + "="
                + weChatContextHolder.getShopAccessToken();
    }

    /**
     * 处理
     */
    public WeChatCoreVO handle(String sharerAppid, Long commissionRatio) {
        WeChatSetSharerCommissionBO params = WeChatSetSharerCommissionBO.builder()
                .sharer_appid(sharerAppid)
                .commission_type(CommissionTypeEnum.PLATFORM.getCode())
                .commission_ratio(commissionRatio)
                .build();
        log.info("[op:WeChatShopSetSharerCommissionRequest.handle]  requestParam={}", JSONObject.toJSONString(params));
        WeChatCoreVO res =  weChatRestTemplateHandler.execute(getRequestUrl(), getRequestMethod(), params, WeChatCoreVO.class);
        log.info("[op:WeChatShopSetSharerCommissionRequest.handle]  res={}", JSONObject.toJSONString(res));
        return res;
    }
}
