package com.netease.yanxuan.wx.store.sharer.integration.handler.impl;

import com.netease.yanxuan.wx.store.sharer.integration.config.WeChatConfig;
import com.netease.yanxuan.wx.store.sharer.integration.constant.WeChatApi;
import com.netease.yanxuan.wx.store.sharer.integration.core.WeChatContextHolder;
import com.netease.yanxuan.wx.store.sharer.integration.handler.IWeChatRequest;
import com.netease.yanxuan.wx.store.sharer.integration.handler.WeChatRestTemplateHandler;
import com.netease.yanxuan.wx.store.sharer.integration.meta.model.bo.WeChatPromoteProductLinkBO;
import com.netease.yanxuan.wx.store.sharer.integration.meta.model.vo.WeChatPromoteProductLinkVO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Service;

/**
 * @Description 商品推广链接
 * @Author fanjiaxin
 * @Date 2025/3/11 17:33
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class WeChatShopPromoteProductLinkRequest implements IWeChatRequest {
    private final WeChatContextHolder weChatContextHolder;
    private final WeChatRestTemplateHandler weChatRestTemplateHandler;
    private final WeChatConfig weChatConfig;


    @Override
    public HttpMethod getRequestMethod() {
        return HttpMethod.POST;
    }

    @Override
    public String getRequestUrl() {
        return weChatConfig.getUrl() + WeChatApi.GET_PRODUCT_PROMOTION_LINK_INFO
                + "?" + WeChatApi.WECHAT_REQUEST_TOKEN_FIELD_NAME + "="
                + weChatContextHolder.getShopAccessToken();
    }

    /**
     * 处理
     */
    public WeChatPromoteProductLinkVO handle(Integer productId, String shopAppid) {
        WeChatPromoteProductLinkBO params = WeChatPromoteProductLinkBO.builder()
                .product_id(productId)
                .shop_appid(shopAppid)
                .build();
        return weChatRestTemplateHandler.execute(getRequestUrl(), getRequestMethod(), params, WeChatPromoteProductLinkVO.class);
    }
}
