package com.netease.yanxuan.wx.store.sharer.biz.service;

import com.netease.yanxuan.wx.store.sharer.biz.meta.model.vo.ProductListVO;
import com.netease.yanxuan.wx.store.sharer.biz.meta.model.vo.ProductPromotionLinkVO;
import com.netease.yanxuan.wx.store.sharer.biz.meta.page.PageQuery;
import com.netease.yanxuan.wx.store.sharer.biz.meta.page.PageVO;
import com.netease.yanxuan.wx.store.sharer.integration.meta.model.vo.WeChatGetSharerProductCommissionVO;
import com.netease.yanxuan.wx.store.sharer.integration.meta.model.vo.WeChatSharerListVO;

/**
 * @Description 商品-业务层
 * @Author fanjiaxin
 * @Date 2025/3/10 12:28
 */
public interface IProductService {

    /**
     * 获取商品分页列表
     */
    PageVO<ProductListVO> getProductPageList(PageQuery pageQuery, String keyword);

    /**
     * 商品分享短链
     */
    ProductPromotionLinkVO getProductPromotionLink(String sharerAppid, String productId);

    /**
     * 获取获取机构绑定的推客信息
     */
    WeChatSharerListVO getBindSharerList(String sharerOpenid);

    /**
     * 获取推客的某个商品的推广分佣比例
     */
    WeChatGetSharerProductCommissionVO getSharerProductCommissionInfo(String sharerAppid, String productId);
}
