package com.netease.yanxuan.wx.store.sharer.integration.task;

import com.netease.yanxuan.wx.store.sharer.integration.core.WeChatContextHolder;
import com.netease.yanxuan.wx.store.sharer.integration.handler.impl.WeChatAccessTokenRequest;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.CommandLineRunner;
import org.springframework.stereotype.Component;

/**
 * @Description 华能e购认证信息初始化
 * @Date 2025/2/24 11:57
 */
@Slf4j
@RequiredArgsConstructor
@Component
public class WeChatAuthTask implements CommandLineRunner {
    private final WeChatAccessTokenRequest weChatAccessTokenRequest;
    private final WeChatContextHolder weChatContextHolder;


    @Override
    public void run(String... args) {
        log.info("微信认证信息初始化开始...");
        try {
            weChatContextHolder.getAccessToken();
            log.info("微信认证信息初始化完成");
        } catch (Exception e) {
            log.error("微信认证信息初始化失败", e);
        }
    }
}
