/**
 * @(#)TestController.java, 2025/3/10.
 * <p/>
 * Copyright 2025 Netease, Inc. All rights reserved.
 * NETEASE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.netease.yanxuan.wx.store.sharer.web.controller;

import com.netease.yanxuan.wx.store.sharer.biz.service.ICommissionOrderService;
import com.netease.yanxuan.wx.store.sharer.common.core.Result;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author 刘运星 (liuyunxing01@corp.netease.com)
 */
@RestController
@RequestMapping("/sharer/test")
@RequiredArgsConstructor
public class TestController {
    private final ICommissionOrderService iCommissionOrderService;

    /**
     * 登录
     */
    @GetMapping("/syncCommissionOrder")
    public Result<Void> syncCommissionOrder(@RequestParam("startTime") Long startTime,
                                            @RequestParam("endTime") Long endTime) {
        iCommissionOrderService.doCommissionOrderSync(startTime, endTime);
        return Result.ok();
    }
}