/**
 * @(#)UasClientImpl.java, 2022/7/27.
 * <p/>
 * Copyright 2022 Netease, Inc. All rights reserved.
 * NETEASE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.netease.yanxuan.wx.store.sharer.integration.client.impl;

import com.alibaba.fastjson.JSON;
import com.netease.yanxuan.missa.specs.interfaces.response.MissaResponse;
import com.netease.yanxuan.wx.store.sharer.integration.client.IUserInfoClient;
import com.netease.yanxuan.wx.store.sharer.integration.facade.UserInfoFacade;
import com.netease.yanxuan.wx.store.sharer.integration.meta.model.bo.UserInfoVerifyByIdentityNoBO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;


@Slf4j
@RequiredArgsConstructor
@Service
public class UserInfoClientImpl implements IUserInfoClient {
    private final UserInfoFacade userInfoFacade;

    @Override
    public Boolean verifyByIdentityNo(String realName, String identityNo) {
        log.info("[op:UserInfoClientImpl:verifyByIdentityNo] realName:{}, identityNo:{}", realName, identityNo);
        try {
            UserInfoVerifyByIdentityNoBO bo = UserInfoVerifyByIdentityNoBO.builder().realName(realName).identityNo(identityNo).build();
            MissaResponse<Boolean> missaResponse = userInfoFacade.verifyByIdentityNo(bo);
            log.info("[op:UserInfoClientImpl:verifyByIdentityNo] missaResponse:{}", JSON.toJSONString(missaResponse));
            if (null != missaResponse && missaResponse.isOK()) {
                return missaResponse.getData();
            }
        } catch (Exception e) {
            log.error("[op:UserInfoClientImpl:verifyByIdentityNo] is error", e);
        }
        return false;
    }
}
