ALTER TABLE `SHARER_INFO` ADD `username` varchar(64) NOT NULL DEFAULT '' COMMENT '姓名' AFTER `commission_type`;
ALTER TABLE `SHARER_INFO` ADD `id_card_number` varchar(32) NOT NULL DEFAULT '' COMMENT '身份证号' AFTER `username`;
ALTER TABLE `SHARER_INFO` ADD `mobile_phone` varchar(16) NOT NULL DEFAULT '' COMMENT '手机号' AFTER `id_card_number`;


CREATE TABLE `SHARER_ORDER_SYNC_FAIL` (
                                          `id` bigint(32) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键ID',
                                          `order_id` varchar(64) NOT NULL DEFAULT '' COMMENT '订单号',
                                          `sku_id` varchar(64) NOT NULL DEFAULT '' COMMENT '商品skuid',
                                          `retry_count` int unsigned NOT NULL DEFAULT 0 COMMENT '重试次数',
                                          `fail_msg` text DEFAULT NULL COMMENT '失败信息',
                                          `create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
                                          `update_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '更新时间',
                                          PRIMARY KEY (`id`),
                                          UNIQUE KEY `uk_order_id_sku_id` (`order_id`, `sku_id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4 COMMENT='推客佣金单同步失败表';


CREATE TABLE `SHARER_ORDER` (
                                `id` bigint(32) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键ID',
                                `order_id` varchar(64) NOT NULL DEFAULT '' COMMENT '订单号',
                                `sku_id` varchar(64) NOT NULL DEFAULT '' COMMENT '商品skuid',
                                `commission_status` varchar(32) NOT NULL DEFAULT '' COMMENT '佣金单状态',
                                `order_status` varchar(32) NOT NULL DEFAULT '' COMMENT '订单状态',
                                `order_create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '订单创建时间',
                                `order_update_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '订单更新时间',
                                `create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
                                PRIMARY KEY (`id`),
                                UNIQUE KEY `uk_order_id_sku_id` (`order_id`, `sku_id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4 COMMENT='推客佣金单表';


CREATE TABLE `SHARER_ORDER_PRODUCT` (
                                        `id` bigint(32) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键ID',
                                        `sharer_order_id` bigint(32) unsigned NOT NULL COMMENT '佣金单ID',
                                        `shop_appid` varchar(64) NOT NULL DEFAULT '' COMMENT '店铺ID',
                                        `product_id` varchar(64) NOT NULL DEFAULT '' COMMENT '商品id',
                                        `thumb_img` varchar(1024) NOT NULL DEFAULT '' COMMENT 'sku小图',
                                        `actual_payment` int unsigned NOT NULL DEFAULT 0 COMMENT '可分佣金额',
                                        `title` varchar(256) NOT NULL DEFAULT '' COMMENT '商品标题',
                                        PRIMARY KEY (`id`),
                                        KEY `idx_sharer_order_id` (`sharer_order_id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4 COMMENT='推客佣金单商品表';


CREATE TABLE `SHARER_ORDER_COMMISSION` (
                                           `id` bigint(32) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键ID',
                                           `sharer_order_id` bigint(32) unsigned NOT NULL COMMENT '佣金单ID',
                                           `service_ratio` int unsigned NOT NULL DEFAULT 0 COMMENT '服务费率[0, 1000000]',
                                           `service_amount` int unsigned NOT NULL DEFAULT 0 COMMENT '服务费金额',
                                           `profit_sharding_suc_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '服务费结算时间',
                                           `promotion_channel` int unsigned NOT NULL DEFAULT 1 COMMENT '0-橱窗带货，1-推客带货',
                                           `promotion_info` text DEFAULT NULL COMMENT '作为推客的时候，推广的一些参数',
                                           PRIMARY KEY (`id`),
                                           KEY `idx_sharer_order_id` (`sharer_order_id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4 COMMENT='推客佣金单分佣表';


CREATE TABLE `SHARER_ORDER_COMMISSION_SHARER` (
                                                  `id` bigint(32) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键ID',
                                                  `sharer_order_id` bigint(32) unsigned NOT NULL COMMENT '佣金单ID',
                                                  `sharer_order_commission_id` bigint(32) unsigned NOT NULL COMMENT '佣金单分佣ID',
                                                  `sharer_appid` varchar(64) NOT NULL DEFAULT '' COMMENT '推客appid',
                                                  `nickname` varchar(64) NOT NULL DEFAULT '' COMMENT '推客昵称',
                                                  `ratio` int unsigned NOT NULL DEFAULT 0 COMMENT '推客佣金率[0, 1000000]',
                                                  `amount` int unsigned NOT NULL DEFAULT 0 COMMENT '推客佣金',
                                                  `opensharerid` varchar(128) NOT NULL DEFAULT '' COMMENT '推客的opensharerid',
                                                  PRIMARY KEY (`id`),
                                                  KEY `idx_sharer_order_id` (`sharer_order_id`),
                                                  KEY `idx_sharer_order_commission_id` (`sharer_order_commission_id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4 COMMENT='推客佣金单分佣推客表';



CREATE TABLE `SHARER_ORDER_COMMISSION_SUB_AGENCY` (
                                                      `id` bigint(32) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键ID',
                                                      `sharer_order_id` bigint(32) unsigned NOT NULL COMMENT '佣金单ID',
                                                      `sharer_order_commission_id` bigint(32) unsigned NOT NULL COMMENT '佣金单分佣ID',
                                                      `appid` varchar(128) NOT NULL DEFAULT '' COMMENT '帮卖机构appid',
                                                      `nickname` varchar(128) NOT NULL DEFAULT '' COMMENT '帮卖机构昵称',
                                                      `ratio` int unsigned NOT NULL DEFAULT 0 COMMENT '帮卖机构服务费率[0, 1000000]',
                                                      `amount` int unsigned NOT NULL DEFAULT 0 COMMENT '帮卖机构服务费',
                                                      `profit_sharding_suc_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '帮卖机构服务费结算时间',
                                                      PRIMARY KEY (`id`),
                                                      KEY `idx_sharer_order_id` (`sharer_order_id`),
                                                      KEY `idx_sharer_order_commission_id` (`sharer_order_commission_id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4 COMMENT='推客佣金单分佣帮卖机构表';



CREATE TABLE `SHARER_ORDER_COMMISSION_PROMOTER_AGENCY` (
                                                           `id` bigint(32) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键ID',
                                                           `sharer_order_id` bigint(32) unsigned NOT NULL COMMENT '佣金单ID',
                                                           `sharer_order_commission_id` bigint(32) unsigned NOT NULL COMMENT '佣金单分佣ID',
                                                           `appid` varchar(128) NOT NULL DEFAULT '' COMMENT '推客机构appid',
                                                           `nickname` varchar(128) NOT NULL DEFAULT '' COMMENT '推客机构昵称',
                                                           `ratio` int unsigned NOT NULL DEFAULT 0 COMMENT '推客机构服务费率[0, 1000000]',
                                                           `amount` int unsigned NOT NULL DEFAULT 0 COMMENT '推客机构服务费',
                                                           `profit_sharding_suc_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '推客机构服务费结算时间',
                                                           PRIMARY KEY (`id`),
                                                           KEY `idx_sharer_order_id` (`sharer_order_id`),
                                                           KEY `idx_sharer_order_commission_id` (`sharer_order_commission_id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4 COMMENT='推客佣金单分佣推客机构表';


CREATE TABLE `SHARER_ORDER_COMMISSION_TALENT` (
                                                  `id` bigint(32) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键ID',
                                                  `sharer_order_id` bigint(32) NOT NULL COMMENT '佣金单ID',
                                                  `sharer_order_commission_id` bigint(32) NOT NULL COMMENT '佣金单分佣ID',
                                                  `talent_appid` varchar(64) NOT NULL DEFAULT '' COMMENT '新带货达人appid',
                                                  `nickname` varchar(64) NOT NULL DEFAULT '' COMMENT '达人昵称',
                                                  `ratio` int NOT NULL DEFAULT 0 COMMENT '达人佣金率[0, 1000000]',
                                                  `amount` int NOT NULL DEFAULT 0 COMMENT '达人佣金',
                                                  `opentalentid` varchar(64) NOT NULL DEFAULT '' COMMENT '带货助手的opentalentid',
                                                  PRIMARY KEY (`id`),
                                                  KEY `idx_sharer_order_id` (`sharer_order_id`),
                                                  KEY `idx_sharer_order_commission_id` (`sharer_order_commission_id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4 COMMENT='推客佣金单分佣达人表';



CREATE TABLE `SHARER_ORDER_COMMISSION_FINDER` (
                                                  `id` bigint(32) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键ID',
                                                  `sharer_order_id` bigint(32) unsigned NOT NULL COMMENT '佣金单ID',
                                                  `sharer_order_commission_id` bigint(32) unsigned NOT NULL COMMENT '佣金单分佣ID',
                                                  `nickname` varchar(128) NOT NULL DEFAULT '' COMMENT '视频号昵称',
                                                  `ratio` int unsigned NOT NULL DEFAULT 0 COMMENT '佣金率[0, 1000000]',
                                                  `amount` int unsigned NOT NULL DEFAULT 0 COMMENT '佣金',
                                                  `openfinderid` varchar(128) NOT NULL DEFAULT '' COMMENT '视频号openfinderid',
                                                  PRIMARY KEY (`id`),
                                                  KEY `idx_sharer_order_id` (`sharer_order_id`),
                                                  KEY `idx_sharer_order_commission_id` (`sharer_order_commission_id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4 COMMENT='推客佣金单分佣视频号达人表';



CREATE TABLE `SHARER_ORDER_BUYER` (
                                      `id` bigint(32) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键ID',
                                      `sharer_order_id` bigint(32) unsigned NOT NULL COMMENT '佣金单ID',
                                      `open_id` varchar(64) NOT NULL DEFAULT '' COMMENT '购买者的openid',
                                      `union_id` varchar(512) NOT NULL DEFAULT '' COMMENT '购买者的unionid',
                                      PRIMARY KEY (`id`),
                                      KEY `idx_sharer_order_id` (`sharer_order_id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4 COMMENT='推客佣金单买家表';
