/**
 * @(#)UasClientImpl.java, 2022/7/27.
 * <p/>
 * Copyright 2022 Netease, Inc. All rights reserved.
 * NETEASE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.netease.yanxuan.wx.store.sharer.integration.client.impl;

import com.alibaba.fastjson.JSON;
import com.netease.yanxuan.missa.specs.interfaces.response.MissaResponse;
import com.netease.yanxuan.wx.store.sharer.integration.client.IUasClient;
import com.netease.yanxuan.wx.store.sharer.integration.facade.UasFacade;
import com.netease.yanxuan.wx.store.sharer.integration.meta.model.bo.SmsCodeScenesConfigBO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;


@Slf4j
@RequiredArgsConstructor
@Service
public class UasClientImpl implements IUasClient {

    private final UasFacade uasFacade;

    private static final String TOPIC_FORMAT = "verify_%s";

    /**
     * 发送验证码
     *
     * @param phone  手机号码
     * @param code   验证码
     * @param scenes 业务场景标识
     * @return
     */
    @Override
    public boolean sendSmsCode(String uid, String phone, String code,
                               String scenes, SmsCodeScenesConfigBO scenesConfigBO) {
        // 构建入参
        MultiValueMap<String, Object> params = assembleSmsArg(uid, phone, code, scenes, scenesConfigBO);
        log.info("[op:UasClientImpl:sendSmsCode] params:{}", JSON.toJSONString(params));
        try {
            MissaResponse<Void> missaResponse = uasFacade.pushSmsCode(params);
            log.info("[op:UasClientImpl:sendSmsCode] rpcResult:{}", JSON.toJSONString(missaResponse));
            return null != missaResponse && missaResponse.isOK() && HttpStatus.OK.value() == missaResponse.getCode();
        } catch (Exception e) {
            log.error("[op:UasClientImpl:sendSmsCode] is error", e);
        }
        return false;
    }


    private MultiValueMap<String, Object> assembleSmsArg(String uid, String phone,
                                               String code, String scenes,
                                               SmsCodeScenesConfigBO scenesConfigBO) {
        MultiValueMap<String, Object> params = new LinkedMultiValueMap<>(5);
        params.add("phone", phone);
        params.add("message", String.format(scenesConfigBO.getMessageFormat(), code, scenesConfigBO.getCodeValidMinutes()));
        params.add("level", 1);
        params.add("uid", uid);
        params.add("topic", String.format(TOPIC_FORMAT, scenes));
        return params;
    }
}
