/**
 * @(#)UasClientImpl.java, 2022/7/27.
 * <p/>
 * Copyright 2022 Netease, Inc. All rights reserved.
 * NETEASE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.netease.yanxuan.wx.store.sharer.integration.client.impl;

import com.alibaba.fastjson.JSON;
import com.netease.yanxuan.wx.store.sharer.common.exception.BizException;
import com.netease.yanxuan.wx.store.sharer.integration.client.IUasClient;
import com.netease.yanxuan.wx.store.sharer.integration.config.RpcConfig;
import com.netease.yanxuan.wx.store.sharer.integration.handler.RestTemplateHandler;
import com.netease.yanxuan.wx.store.sharer.integration.meta.model.bo.SendSmsCodeBO;
import com.netease.yanxuan.wx.store.sharer.integration.meta.model.bo.SmsCodeScenesConfigBO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;


@Slf4j
@RequiredArgsConstructor
@Service
public class UasClientImpl implements IUasClient {

    private final RpcConfig rpcConfig;
    private final RestTemplateHandler restTemplateHandler;


    private static final String PRODUCT = "yanxuan-wx-store-sharer";
    private static final String SMS_SEND_PATH = "/push/sms/";
    private static final String TOPIC_FORMAT = "verify_%s";

    /**
     * 发送验证码
     *
     * @param phone  手机号码
     * @param code   验证码
     * @param scenes 业务场景标识
     * @return
     */
    @Override
    public boolean sendSmsCode(String uid, String phone, String code,
                               String scenes, SmsCodeScenesConfigBO scenesConfigBO) {
        Map<String, Object> params = assembleSmsArg(uid, phone, code, scenes, scenesConfigBO);
        log.error("[op:UasClientImpl:sendSmsCode] params:{}", JSON.toJSONString(params));
        String httpUrl = rpcConfig.getUasUrl() + SMS_SEND_PATH + PRODUCT;
        try {
            log.error("[op:UasClientImpl:sendSmsCode] httpUrl:{}", httpUrl);
            SendSmsCodeBO rpcResult = restTemplateHandler.execute(httpUrl, HttpMethod.POST, params, SendSmsCodeBO.class);
            log.error("[op:UasClientImpl:sendSmsCode] rpcResult:{}", JSON.toJSONString(rpcResult));
            if(null == rpcResult){
                return false;
            }
            if(HttpStatus.OK.value() == rpcResult.getCode()){
                return true;
            }
            if(StringUtils.isNotBlank(rpcResult.getErrorCode())){
                throw new BizException(rpcResult.getErrorCode());
            }
        } catch (Exception e) {
            log.error("[op:UasClientImpl:sendSmsCode] is error", e);
        }
        return false;
    }


    private Map<String, Object> assembleSmsArg(String uid, String phone,
                                               String code, String scenes,
                                               SmsCodeScenesConfigBO scenesConfigBO) {
        Map<String, Object> params = new HashMap<>();
        params.put("phone", phone);
        params.put("message", String.format(scenesConfigBO.getMessageFormat(), code, scenesConfigBO.getCodeValidMinutes()));
        params.put("level", 1);
        params.put("uid", uid);
        params.put("topic", String.format(TOPIC_FORMAT, scenes));
        return params;
    }
}
