-- 推客信息表
CREATE TABLE SHARER_INFO
(
    `id`               bigint(20) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键ID',
    `open_id`          varchar(64)   NOT NULL DEFAULT '' COMMENT '用户开放ID',
    `sharer_appid`     varchar(64)   NOT NULL DEFAULT '' COMMENT '推客应用ID',
    `bind_time`        datetime      NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '绑定时间',
    `commission_ratio` decimal(5, 2) NOT NULL DEFAULT 0.00 COMMENT '佣金比例',
    `commission_type`  varchar(32)   NOT NULL DEFAULT '' COMMENT '佣金类型',
    `create_time`      datetime      NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
    `update_time`      datetime      NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '更新时间',
    PRIMARY KEY (`id`),
    INDEX              idx_open_id (open_id),
    INDEX              idx_sharer_appid (sharer_appid)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4 COMMENT='推客信息表';


-- 推客商品分佣表
CREATE TABLE SHARER_PRODUCT_COMMISSION
(
    `id`               bigint(20) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键ID',
    `open_id`          varchar(64)   NOT NULL DEFAULT '' COMMENT '用户开放ID',
    `sharer_appid`     varchar(64)   NOT NULL DEFAULT '' COMMENT '推客应用ID',
    `product_id`       varchar(64)   NOT NULL DEFAULT '' COMMENT '商品ID',
    `commission_ratio` decimal(5, 2) NOT NULL DEFAULT 0.00 COMMENT '佣金比例',
    `commission_type`  varchar(32)   NOT NULL DEFAULT '' COMMENT '佣金类型',
    `unset`            int(11)     NOT NULL DEFAULT 1 COMMENT '是否未配置，1：未配置，取默认佣金比例，0：已配置',
    `create_time`      datetime      NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
    `update_time`      datetime      NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '更新时间',
    PRIMARY KEY (`id`),
    INDEX              idx_open_id (open_id),
    INDEX              idx_sharer_appid (sharer_appid)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4 COMMENT='推客商品分佣表';


-- 推客商品分佣配置操作记录表
CREATE TABLE SHARER_PRODUCT_COMMISSION_RECORD
(
    `id`           bigint(20) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键ID',
    `open_id`      varchar(64)   NOT NULL DEFAULT '' COMMENT '用户开放ID',
    `sharer_appid` varchar(64)   NOT NULL DEFAULT '' COMMENT '推客应用ID',
    `product_id`   varchar(64)   NOT NULL DEFAULT '' COMMENT '商品ID',
    `opt_type`     varchar(32)   NOT NULL DEFAULT '' COMMENT '操作类型',
    `opt_info`     varchar(256)  NOT NULL DEFAULT '' COMMENT '操作信息，记录操作前比例 & 操作后比例',
    `opt_time`     datetime      NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '操作时间',
    `opt_status`   varchar(1)    NOT NULL DEFAULT '1' COMMENT '状态，1 操作成功 2 操作失败',
    `ext_info`     varchar(1024) NOT NULL DEFAULT '' COMMENT '拓展信息',
    `create_time`  datetime      NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
    `update_time`  datetime      NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '更新时间',
    PRIMARY KEY (`id`),
    INDEX          idx_open_id (open_id),
    INDEX          idx_sharer_appid (sharer_appid),
    INDEX          idx_product_id (product_id)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4 COMMENT='推客商品分佣配置操作记录表';