/**
 * @(#)PhoneCheckUtils.java, 2022/7/25.
 * <p/>
 * Copyright 2022 Netease, Inc. All rights reserved.
 * NETEASE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.netease.yanxuan.wx.store.sharer.common.util;

import org.apache.commons.lang3.StringUtils;

import java.util.regex.Pattern;

/**
 * @author 张艳(wb.zhangyan12 @ mesg.corp.netease.com)
 */
public class PhoneCheckUtils {

    private static final String regex = "^[1][0-9]{10}$";

    /**
     * 手机号码格式验证
     *
     * @param phone 手机号
     */
    public static boolean checkPhoneFormat(String phone) {
        if (StringUtils.isBlank(phone)) {
            return false;
        }
        if (phone.length() != 11) {
            return false;
        } else {
            return Pattern.compile(regex).matcher(phone).matches();
        }
    }

}