package com.netease.yanxuan.wx.store.sharer.integration.handler.impl;

import com.netease.yanxuan.wx.store.sharer.integration.config.WeChatConfig;
import com.netease.yanxuan.wx.store.sharer.integration.constant.WeChatApi;
import com.netease.yanxuan.wx.store.sharer.integration.handler.IWeChatRequest;
import com.netease.yanxuan.wx.store.sharer.integration.handler.WeChatRestTemplateHandler;
import com.netease.yanxuan.wx.store.sharer.integration.meta.model.bo.WeChatUserInfoBO;
import com.netease.yanxuan.wx.store.sharer.integration.meta.model.vo.WeChatUserInfoVO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Service;

/**
 * @Description 微信凭证请求
 * @Author fanjiaxin
 * @Date 2025/3/11 17:33
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class WeChatUserInfoRequest implements IWeChatRequest {
    private final WeChatRestTemplateHandler weChatRestTemplateHandler;
    private final WeChatConfig weChatConfig;

    private static final String GRANT_TYPE = "authorization_code";

    @Override
    public HttpMethod getRequestMethod() {
        return HttpMethod.GET;
    }

    @Override
    public String getRequestUrl() {
        return weChatConfig.getUrl() + WeChatApi.GET_USER_INFO;
    }

    /**
     * 处理
     */
    public WeChatUserInfoVO handle(String code) {
        WeChatUserInfoBO params = WeChatUserInfoBO.builder()
                .appid(weChatConfig.getAppid())
                .secret(weChatConfig.getAppsecret())
                .js_code(code)
                .grant_type(GRANT_TYPE)
                .build();
        return weChatRestTemplateHandler.execute(getRequestUrl(), getRequestMethod(), params, WeChatUserInfoVO.class);
    }
}
