package com.netease.yanxuan.wx.store.sharer.biz.meta.enums;

import lombok.Getter;
import lombok.RequiredArgsConstructor;

/**
 * @Description 短信场景枚举
 * @Author fanjiaxin
 * @Date 2025/5/14 13:12
 */
@Getter
@RequiredArgsConstructor
public enum SmsScenesEnum {

    REAL_NAME_AUTHENTICATED("实名认证");

    private final String desc;

    /**
     * 检查场景标识是否存在
     *
     * @param scenes 场景标识
     * @return true:存在，false: 不存在
     */
    public static boolean checkScenes(String scenes) {
        for (SmsScenesEnum scenesEnum : SmsScenesEnum.values()) {
            if (scenesEnum.name().equals(scenes)) {
                return true;
            }
        }
        return false;
    }
}