package com.netease.yanxuan.wx.store.sharer.integration.constant;

/**
 * @Description 微信常量信息
 * @Author fanjiaxin
 * @Date 2025/3/9 13:15
 */
public interface WeChatConstant {

    /**
     * Redis微信认证Token
     */
    String REDIS_TOKEN_WECHAT_KEY = "TOKEN:WECHAT";
    /**
     * Redis微信认证Token锁
     */
    String REDIS_TOKEN_WECHAT_LOCK_KEY = "TOKEN:WECHAT:LOCK";
    /**
     * Redis微信认证Token锁时间，秒
     */
    String REDIS_TOKEN_WECHAT_LOCK_VALUE = "wechat:lock";
    /**
     * Redis微信认证Token锁时间，秒
     */
    int REDIS_TOKEN_WECHAT_LOCK_TIME = 5;

    /**
     * Redis微信小店认证Token
     */
    String REDIS_TOKEN_WECHAT_SHOP_KEY = "TOKEN:WECHAT:SHOP";
    /**
     * Redis微信小店认证Token锁
     */
    String REDIS_TOKEN_WECHAT_SHOP_LOCK_KEY = "TOKEN:WECHAT:SHOP:LOCK";
    /**
     * Redis微信小店认证Token锁时间，秒
     */
    String REDIS_TOKEN_WECHAT_SHOP_LOCK_VALUE = "wechat:shop:lock";
    /**
     * Redis微信小店认证Token锁时间，秒
     */
    int REDIS_TOKEN_WECHAT_SHOP_LOCK_TIME = 5;

    /**
     * Redis商品详情缓存KEY
     */
    String REDIS_PRODUCT_DETAIL_KEY = "PRODUCT:DETAIL:";

    /**
     * Redis商品详情过期时间，秒
     */
    int REDIS_PRODUCT_DETAIL_EXPIRE_SECONDS = 6 * 60 * 60;
}
