package com.netease.yanxuan.wx.store.sharer.web.controller;

import com.netease.yanxuan.wx.store.sharer.biz.meta.model.bo.SmsCodeBO;
import com.netease.yanxuan.wx.store.sharer.biz.service.ISmsService;
import com.netease.yanxuan.wx.store.sharer.common.core.Result;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @Description 短信-控制器
 * @Author fanjiaxin
 * @Date 2025/3/9 13:10
 */
@RequiredArgsConstructor
@RestController
@RequestMapping("/sharer/sms")
@Slf4j
public class SmsController extends BaseController {
    private final ISmsService iSmsService;


    /**
     * 发送短信验证码
     */
    @PostMapping("/sendSmsCode")
    public Result<Boolean> sendSmsCode(@Validated @RequestBody SmsCodeBO bo) {
        iSmsService.sendSmsCode(bo);
        return Result.ok(true);
    }
}
