package com.netease.yanxuan.wx.store.sharer.integration.meta.model.vo;

import lombok.Data;
import lombok.Getter;
import lombok.RequiredArgsConstructor;

/**
 * @Description 分佣单列表项-视图对象
 * @Author fanjiaxin
 * @Date 2025/5/11 19:05
 */
@Data
public class WeChatCommissionOrderDetailVO extends WeChatCoreVO {
    private static final long serialVersionUID = 8529644543147459802L;

    /**
     * 订单号
     */
    private String order_id;
    /**
     * 商品skuid
     */
    private Long sku_id;
    /**
     * 秒级时间戳
     */
    private Long create_time;
    /**
     * 秒级时间戳
     */
    private Long update_time;
    /**
     * 佣金单状态，枚举值详情请参考 CommissionOrderStatus
     */
    private Integer status;
    /**
     * 订单详情，结构体详情请参考OrderDetail
     */
    private OrderDetailVO order_detail;


    @Data
    public class OrderDetailVO {
        /**
         * 小店商家信息，结构体详情请参考BizInfo
         */
        private BizInfoVO shop_info;
        /**
         * 佣金单商品信息，结构体详情请参考 ProductInfo
         */
        private ProductInfoVO product_info;
        /**
         * 订单信息，结构体详情请参考 OrderInfo
         */
        private OrderInfoVO order_info;
        /**
         * 分佣信息，结构体详情请参考 CommissionInfo
         */
        private CommissionInfoVO commission_info;
        /**
         * 买家信息，结构体详情请参考 BuyerInfo
         */
        private BuyerInfoVO buyer_info;
    }

    @Data
    public class BizInfoVO {
        /**
         * 所属小店appid
         */
        private String appid;
    }

    @Data
    public class ProductInfoVO {
        /**
         * 商品id
         */
        private String product_id;
        /**
         * sku小图
         */
        private String thumb_img;
        /**
         * 可分佣金额
         */
        private Integer actual_payment;
        /**
         * 商品标题
         */
        private String title;
    }

    @Data
    public class OrderInfoVO {
        /**
         * 订单状态，枚举值详情请参考OrderStatus
         */
        private Integer status;
    }

    @Data
    public class CommissionInfoVO {
        /**
         * 视频号达人信息，结构体详情请参考 FinderInfo
         */
        private FinderInfoVO finder_info;
        /**
         * 服务费率[0, 1000000]
         */
        private Integer service_ratio;
        /**
         * 服务费金额
         */
        private Integer service_amount;
        /**
         * 服务费结算时间
         */
        private Long profit_sharding_suc_time;
        /**
         * 0-橱窗带货，1-推客带货
         */
        private Integer promotion_channel;
        /**
         * 推客分佣信息，结构体详情请参考 SharerInfo
         */
        private SharerInfoVO sharer_info;
        /**
         * 新带货达人信息，结构体详情请参考 TalentInfo
         */
        private TalentInfoVO talent_info;
        /**
         * 作为推客的时候，推广的一些参数，结构体详情请参考 PromotionInfo
         */
        private PromotionInfoVO promotion_info;
        /**
         * 帮卖机构分佣，结构体详情请参考 AgencyInfo
         */
        private AgencyInfoVO sub_agency_info;
        /**
         * 推客机构分佣，结构体详情请参考 AgencyInfo
         */
        private AgencyInfoVO promoter_agency_info;
    }

    @Data
    public class BuyerInfoVO {
        /**
         * 购买者的openid
         */
        private String open_id;
        /**
         * 购买者的unionid
         */
        private String union_id;
    }

    @Data
    public class FinderInfoVO {
        /**
         * 视频号昵称
         */
        private String nickname;
        /**
         * 佣金率[0, 1000000]
         */
        private Integer ratio;
        /**
         * 佣金
         */
        private Integer amount;
        /**
         * 视频号openfinderid
         */
        private String openfinderid;
    }

    @Data
    public class SharerInfoVO {
        /**
         * 推客appid
         */
        private String sharer_appid;
        /**
         * 推客昵称
         */
        private String nickname;
        /**
         * 佣金率[0, 1000000]
         */
        private Integer ratio;
        /**
         * 佣金
         */
        private Integer amount;
        /**
         * 推客的opensharerid
         */
        private String opensharerid;
    }

    @Data
    public class TalentInfoVO {
        /**
         * 新带货达人appid
         */
        private String talent_appid;
        /**
         * 达人昵称
         */
        private String nickname;
        /**
         * 佣金率[0, 1000000]
         */
        private Integer ratio;
        /**
         * 佣金
         */
        private Integer amount;
        /**
         * 带货助手的opentalentid
         */
        private String opentalentid;
    }

    @Data
    public class AgencyInfoVO {
        /**
         * 机构appid
         */
        private String appid;
        /**
         * 帮卖机构昵称
         */
        private String nickname;
        /**
         * 服务费率[0, 1000000]
         */
        private Integer ratio;
        /**
         * 服务费
         */
        private Integer amount;
        /**
         * 服务费结算时间
         */
        private Long profit_sharding_suc_time;
    }

    @Data
    public class PromotionInfoVO {
        /**
         * 推客推广的类型 【0：无 3:私域商品推广 4:带货内容推广 6:自营内容推广】
         */
        private Integer channel_type;
        /**
         * 推广渠道来自视频号时的视频号信息
         */
        private PromotionFinderInfoVO finder_info;
        /**
         * 推广渠道来自公众号的公众号信息
         */
        private PromotionMpInfoVO mp_info;
        /**
         * 推广渠道来自带货内容推广时的带货助手信息
         */
        private PromotionTalentInfoVO talent_info;
    }

    @Data
    public class PromotionTalentInfoVO {
        /**
         * 带货助手的appid
         */
        private String talent_appid;
        /**
         * 达人昵称
         */
        private String nickname;
        /**
         * 带货助手的opentalentid
         */
        private String opentalentid;
    }

    @Data
    public class PromotionFinderInfoVO {
        /**
         * 视频号 id
         */
        private String finder_id;
        /**
         * 昵称
         */
        private String nickname;
        /**
         * 视频号的openfinderid
         */
        private String openfinderid;
    }

    @Data
    public class PromotionMpInfoVO {
        /**
         * 公众号的 appid
         */
        private String appid;
        /**
         * 昵称
         */
        private String nickname;
    }


    /**
     * 佣金单状态枚举类
     */
    @Getter
    @RequiredArgsConstructor
    public enum CommissionOrderStatus {
        WAITING_SETTLEMENT(20, "待结算"),
        SETTLED(100, "已结算"),
        CANCELED(200, "取消结算");

        private final Integer code;
        private final String description;
    }

    /**
     * 订单状态枚举类
     */
    @Getter
    @RequiredArgsConstructor
    public enum OrderStatus {
        PENDING_PAYMENT(10, "待付款"),
        AWAITING_GIFT_RECEIPT(12, "待收礼"),
        PENDING_SHIPMENT(20, "待发货"),
        PARTIALLY_SHIPPED(21, "部分发货"),
        PENDING_DELIVERY(30, "待收货"),
        COMPLETED(100, "完成"),
        CANCELLED_AFTER_FULL_AFTERSALES(200, "全部商品售后之后，订单取消"),
        CANCELLED_DUE_TO_NON_PAYMENT(250, "未付款用户主动取消或超时未付款订单自动取消");

        private final Integer code;
        private final String description;
    }
}