package com.netease.yanxuan.wx.store.sharer.dal.meta.model.po;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.Getter;
import lombok.RequiredArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;

/**
 * @Description 推客商品分佣表
 * @Author fanjiaxin
 * @Date 2025/3/11 21:54
 */
@Data
@TableName("SHARER_PRODUCT_COMMISSION")
public class SharerProductCommission implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     * 主键ID，自动生成。
     */
    @TableId(type = IdType.AUTO)
    private BigInteger id;
    /**
     * 用户开放ID
     */
    private String openId;
    /**
     * 推客应用ID
     */
    private String sharerAppid;
    /**
     * 商品ID
     */
    private String productId;
    /**
     * 佣金比例
     */
    private BigDecimal commissionRatio;
    /**
     * 佣金类型
     */
    private String commissionType;
    /**
     * 是否未配置，1：未配置，取默认佣金比例，0：已配置
     */
    private String unset;
    /**
     * 创建时间
     */
    private Date createTime;
    /**
     * 更新时间
     */
    private Date updateTime;


    @Getter
    @RequiredArgsConstructor
    public enum UnsetEnum {
        UNSET("1", "未配置，取默认佣金比例"),
        SET("0", "已配置");

        private final String code;
        private final String desc;
    }
}

