package com.netease.yanxuan.wx.store.sharer.biz.meta.model.vo;

import lombok.Data;

/**
 * @Description 用户信息
 * @Author fanjiaxin
 * @Date 2025/3/11 10:59
 */
@Data
public class SharerInfoVO {
    /**
     * 推客在小程序中的 openid
     */
    private String openId;
    /**
     * 推客在微信电商平台注册的身份标识
     */
    private String sharerAppId;
    /**
     * 和机构的绑定状态
     * 0：未绑定 1：已绑定
     */
    private Integer bindStatus;
    /**
     * 当前推客的注册状态
     * 0：未注册
     * 1：注册中，还未完成
     * 2：已完成注册
     * 3:用户未支付实名，需要把微信先支付实名才能继续注册
     */
    private Integer registerStatus;
    /**
     * register_status等于 0 或者 1时
     * 调用注册流程时，openBusinessView需要的businessType
     */
    private String registerBusinessType;
    /**
     * 注册时需要的queryString参数
     */
    private String registerQueryString;
    /**
     * bind_status等于0时，调用绑定流程时，openBusinessView需要的businessType
     */
    private String bindBusinessType;
    /**
     * 绑定时需要的queryString参数
     */
    private String bindQueryString;
}
