package com.netease.yanxuan.wx.store.sharer.biz.core;

import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;

/**
 * @Description 授权上下文
 * @Author fanjiaxin
 * @Date 2025/3/10 11:10
 */
public class LoginUserContextHolder {

    public static ThreadLocal<LoginUserInfo> HOLDER = new ThreadLocal<>();

    public static void set(LoginUserInfo loginUserInfo) {
        HOLDER.set(loginUserInfo);
    }

    public static LoginUserInfo get() {
        return HOLDER.get();
    }

    public static void remove() {
        HOLDER.remove();
    }

    /**
     * 生成用户Token
     */
    public static String generateToken(String code, String openId) {
        return Jwts.builder()
                .claim("code", code)
                .signWith(SignatureAlgorithm.HS256, openId)
                .compact();
    }
}
