
package com.netease.yanxuan.wx.store.sharer.dal.config;

import com.ctrip.framework.apollo.spring.annotation.EnableAutoUpdateApolloConfig;
import lombok.Getter;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * 数据库配置 不会动态生效,需重启生效
 */
@Getter
@Component
@EnableAutoUpdateApolloConfig("db.config")
public class DrmDBConfig {

    @Value("${mysql.url:}")
    private String mysqlUrl;

    @Value("${mysql.username:}")
    private String mysqlUserName;

    @Value("${mysql.password:}")
    private String mysqlPassWord;

    @Value("${mysql.driverClassName:com.mysql.jdbc.Driver}")
    private String mysqlDriverClassName;

    @Value("${mysql.type:mysql}")
    private String mysqlDbType;

    @Value("${mysql.initial.size:5}")
    private int mysqlInitialSize;

    @Value("${mysql.minIdle:5}")
    private int mysqlMinIdle;

    @Value("${mysql.maxActive:50}")
    private int mysqlMaxActive;

    @Value("${mysql.maxWait:1000}")
    private long mysqlMaxWait;

    @Value("${mysql.minEvictableIdleTimeMillis:35000}")
    private long mysqlMinEvictableTimeMillis;

    @Value("${mysql.removeAbandoned:false}")
    private boolean mysqlRemoveAbandoned;

    @Value("${mysql.removeAbandonedTimeoutMillis:180000}")
    private long mysqlRemoveAbandonedTimeMills;

    @Value("${mysql.connectProperties:socketTimeout=3000;connectTimeout=1200}")
    private String mysqlConnectionProperties;

    @Value("${mysql.useUnfairLock:false}")
    private boolean mysqlUseUnfairLock;

    @Value("${mysql.testWhileIdle:true}")
    private boolean mysqlTestWhileIdle;

    @Value("${mysql.validationQuery:SELECT 1}")
    private String mysqlValidationQuery;

    @Value("${mysql.validationQueryTimeout:1}")
    private int mysqlValidationQueryTimeout;

    @Value("${mysql.timeBetweenEvictionRunsMillis:30000}")
    private long mysqlTimeBetweenEvictionRunsMillis;

    @Value("${mysql.testOnBorrow:false}")
    private boolean mysqlTestOnBorrow;

    @Value("${mysql.testOnReturn:false}")
    private boolean mysqlTestOnReturn;

    @Value("${mysql.poolPreparedStatements:false}")
    private boolean mysqlPoolPreparedStatements;

    @Value("${mysql.maxPoolPreparedStatementPerConnectionSize:0}")
    private int mysqlMaxPoolPreparedStatementPerConnectionSize;

    /**
     * redis
     */
    private List<String> nodes;

    @Value("${redis.cluster.nodes:10.104.0.129:16380,10.104.0.129:16381,10.104.0.129:16382}")
    private String clusterNodes;

    @Value("${redis.cluster.password:}")
    private String password;

    @Value("${redis.cluster.max-redirects:3}")
    private Integer maxRedirects;

    @Value("${redis.maxTotal:100}")
    private Integer maxTotal;

    @Value("${redis.maxIdle:100}")
    private Integer maxIdle;

    @Value("${redis.minIdle:20}")
    private Integer minIdle;

    @Value("${redis.numTestsPerEvictionRun:1024}")
    private Integer numTestsPerEvictionRun;

    @Value("${redis.timeBetweenEvictionRunsMillis:30000}")
    private Integer timeBetweenEvictionRunsMillis;

    @Value("${redis.minEvictableIdleTimeMillis:1800000}")
    private Integer minEvictableIdleTimeMillis;

    @Value("${redis.softMinEvictableIdleTimeMillis:10000}")
    private Integer softMinEvictableIdleTimeMillis;

    @Value("${redis.maxWaitMillis:1500}")
    private Integer maxWaitMillis;

    @Value("${redis.testOnBorrow:false}")
    private Boolean testOnBorrow;

    @Value("${redis.testWhileIdle:true}")
    private Boolean testWhileIdle;

    @Value("${redis.blockWhenExhausted:false}")
    private Boolean blockWhenExhausted;

    public List<String> getClusterNodes() {
        String[] split = this.clusterNodes.split(",");
        nodes = new ArrayList<>(Arrays.asList(split));
        return nodes;
    }
}
