package com.netease.yanxuan.wx.store.sharer.biz.core;

import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;

import java.util.Date;

/**
 * @Description 授权上下文
 * @Author fanjiaxin
 * @Date 2025/3/10 11:10
 */
public class LoginUserContextHolder {

    public static ThreadLocal<LoginUserInfo> HOLDER = new ThreadLocal<>();

    public static void set(LoginUserInfo loginUserInfo) {
        HOLDER.set(loginUserInfo);
    }

    public static LoginUserInfo get() {
        return HOLDER.get();
    }

    public static void remove() {
        HOLDER.remove();
    }

    /**
     * 生成用户Token
     */
    public static String generateToken(String code) {
        return Jwts.builder()
                .claim("time", new Date().getTime())
                .signWith(SignatureAlgorithm.HS256, code)
                .compact();
    }
}
