package com.netease.yanxuan.wx.store.sharer.integration.handler;

import com.netease.yanxuan.wx.store.sharer.common.util.SpringContextUtils;
import com.netease.yanxuan.wx.store.sharer.integration.core.WeChatContextHolder;
import org.springframework.http.HttpMethod;

/**
 * @Description IWeChatRequest
 * @Author fanjiaxin
 * @Date 2025/3/11 17:12
 */
public interface IWeChatRequest {
    /**
     * 请求类型
     */
    HttpMethod getRequestMethod();

    /**
     * 请求地址
     */
    String getRequestUrl();

    default String getAccessToken() {
        WeChatContextHolder weChatContextHolder = SpringContextUtils.getBean(WeChatContextHolder.class);
        return weChatContextHolder.getAccessToken();
    }
}
