package com.netease.yanxuan.wx.store.sharer.integration.handler;

import com.netease.yanxuan.wx.store.sharer.common.exception.BizException;
import com.netease.yanxuan.wx.store.sharer.common.handler.RestTemplateClient;
import com.netease.yanxuan.wx.store.sharer.integration.meta.model.vo.WeChatCoreVO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Service;

/**
 * @Description RestTemplateClient
 * @Author fanjiaxin
 * @Date 2025/3/11 17:27
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class WeChatRestTemplateHandler {
    private final RestTemplateClient restTemplateClient;

    public <T, R extends WeChatCoreVO> R execute(String url, HttpMethod method, T params, Class<R> resType) {
        R result = restTemplateClient.execute(url, method, params, resType);
        if (!"0".equals(result.getErrcode())) {
            throw new BizException("调用微信接口失败，" + result.getErrmsg());
        }
        return result;
    }
}

