package com.netease.yanxuan.wx.store.sharer.web.controller;

import com.netease.yanxuan.wx.store.sharer.biz.meta.model.vo.ProductListVO;
import com.netease.yanxuan.wx.store.sharer.biz.meta.page.PageQuery;
import com.netease.yanxuan.wx.store.sharer.biz.meta.page.PageVO;
import com.netease.yanxuan.wx.store.sharer.biz.service.IProductService;
import com.netease.yanxuan.wx.store.sharer.common.core.Result;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * @Description 商品-控制器
 * @Author fanjiaxin
 * @Date 2025/3/9 13:21
 */
@RequiredArgsConstructor
@RestController
@RequestMapping("/product")
public class ProductController extends BaseController {
    private final IProductService iProductService;


    /**
     * 商品分页列表
     */
    @GetMapping("/page/list")
    public Result<PageVO> getProductPageList(PageQuery pageQuery,
                                             @RequestParam(value = "keyword", required = false) String keyword) {
        PageVO<ProductListVO> pageList = iProductService.getProductPageList(pageQuery, keyword);
        return Result.ok(pageList);
    }

}
